/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerContext;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.ManualIoEventLoop;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.nio.NioIoHandler;
import io.netty.util.concurrent.MockTicker;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.Ticker;
import io.netty.util.internal.ThreadExecutorMap;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class ManualIoEventLoopTest {
    @Test
    public void testRunNow() throws Exception {
        Thread currentThread = Thread.currentThread();
        Semaphore semaphore = new Semaphore(0);
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(currentThread, executor -> new TestIoHandler(semaphore));
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)eventLoop.runNow());
        TestRunnable runnable = new TestRunnable();
        eventLoop.execute((Runnable)runnable);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)runnable.isDone());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)eventLoop.runNow());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)runnable.isDone());
        eventLoop.shutdown();
        while (!eventLoop.isTerminated()) {
            eventLoop.runNow();
        }
        eventLoop.terminationFuture().sync();
    }

    @Test
    public void testRun() throws Exception {
        Thread currentThread = Thread.currentThread();
        Semaphore semaphore = new Semaphore(0);
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(currentThread, executor -> new TestIoHandler(semaphore));
        long waitTime = TimeUnit.MILLISECONDS.toNanos(200L);
        long current = System.nanoTime();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)eventLoop.run(waitTime));
        long actualNanos = System.nanoTime() - current;
        Assertions.assertThat((long)actualNanos).isGreaterThanOrEqualTo(waitTime);
        TestRunnable runnable = new TestRunnable();
        eventLoop.execute((Runnable)runnable);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)runnable.isDone());
        waitTime = TimeUnit.SECONDS.toNanos(1L);
        current = System.nanoTime();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)eventLoop.run(waitTime));
        Assertions.assertThat((long)waitTime).isGreaterThan(System.nanoTime() - current);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)runnable.isDone());
        eventLoop.shutdown();
        while (!eventLoop.isTerminated()) {
            eventLoop.runNow();
        }
        eventLoop.terminationFuture().sync();
    }

    @Test
    public void testShutdownOutSideOfOwningThread() throws Exception {
        Semaphore semaphore = new Semaphore(0);
        Thread ownerThread = new Thread();
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(ownerThread, executor -> new TestIoHandler(semaphore));
        eventLoop.shutdown();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)eventLoop.isShuttingDown());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)semaphore.availablePermits());
    }

    @Test
    public void testCallFromWrongThread() throws Exception {
        Thread thread = new Thread();
        Semaphore semaphore = new Semaphore(0);
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(thread, executor -> new TestIoHandler(semaphore));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ManualIoEventLoop)eventLoop).runNow());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> eventLoop.run(10L));
    }

    @Test
    public void testThreadEventExecutorMap() throws Exception {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Semaphore semaphore = new Semaphore(0);
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(Thread.currentThread(), executor -> new TestIoHandler(semaphore));
        org.junit.jupiter.api.Assertions.assertNull((Object)ThreadExecutorMap.currentExecutor());
        eventLoop.execute(() -> queue.offer(ThreadExecutorMap.currentExecutor()));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)eventLoop.runNow());
        org.junit.jupiter.api.Assertions.assertSame((Object)eventLoop, queue.take());
        eventLoop.shutdown();
        while (!eventLoop.isTerminated()) {
            eventLoop.runNow();
        }
        eventLoop.terminationFuture().sync();
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAnyInEventLoop() {
        ManualIoEventLoopTest.testInvokeInEventLoop(true, false);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAnyInEventLoopWithTimeout() {
        ManualIoEventLoopTest.testInvokeInEventLoop(true, true);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAllInEventLoop() {
        ManualIoEventLoopTest.testInvokeInEventLoop(false, false);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testInvokeAllInEventLoopWithTimeout() {
        ManualIoEventLoopTest.testInvokeInEventLoop(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testInvokeInEventLoop(final boolean any, final boolean timeout) {
        Semaphore semaphore = new Semaphore(0);
        final ManualIoEventLoop eventLoop = new ManualIoEventLoop(Thread.currentThread(), executor -> new TestIoHandler(semaphore));
        try {
            org.junit.jupiter.api.Assertions.assertThrows(RejectedExecutionException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    final Promise promise = eventLoop.newPromise();
                    eventLoop.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Set<1> set = Collections.singleton(new Callable<Boolean>(){

                                    @Override
                                    public Boolean call() {
                                        promise.setFailure((Throwable)((Object)new AssertionError((Object)"Should never execute the Callable")));
                                        return Boolean.TRUE;
                                    }
                                });
                                if (any) {
                                    if (timeout) {
                                        eventLoop.invokeAny(set, 10L, TimeUnit.SECONDS);
                                    } else {
                                        eventLoop.invokeAny(set);
                                    }
                                } else if (timeout) {
                                    eventLoop.invokeAll(set, 10L, TimeUnit.SECONDS);
                                } else {
                                    eventLoop.invokeAll(set);
                                }
                                promise.setFailure((Throwable)((Object)new AssertionError((Object)"Should never reach here")));
                            }
                            catch (Throwable cause) {
                                promise.setFailure(cause);
                            }
                        }
                    });
                    while (!promise.isDone()) {
                        eventLoop.runNow();
                    }
                    promise.syncUninterruptibly();
                }
            });
        }
        finally {
            eventLoop.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            while (!eventLoop.isTerminated()) {
                eventLoop.runNow();
            }
            org.junit.jupiter.api.Assertions.assertTrue((boolean)eventLoop.terminationFuture().isSuccess());
        }
    }

    @Test
    public void testDelayOwningThread() throws ExecutionException, InterruptedException {
        Semaphore semaphore = new Semaphore(0);
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(null, executor -> new TestIoHandler(semaphore));
        Thread thread = new Thread(() -> {
            eventLoop.setOwningThread(Thread.currentThread());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)eventLoop.inEventLoop());
            while (!eventLoop.isTerminated()) {
                eventLoop.runNow();
            }
        });
        org.junit.jupiter.api.Assertions.assertFalse((boolean)eventLoop.inEventLoop());
        CompletableFuture cf = new CompletableFuture();
        eventLoop.execute(() -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)eventLoop.inEventLoop());
            cf.complete(null);
        });
        thread.start();
        cf.get();
        eventLoop.shutdownGracefully();
        thread.join();
    }

    @Test
    public void testRunWithoutOwner() throws ExecutionException, InterruptedException {
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(null, executor -> new TestIoHandler(new Semaphore(0)));
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ((ManualIoEventLoop)eventLoop).runNow());
        eventLoop.setOwningThread(Thread.currentThread());
        eventLoop.runNow();
        eventLoop.shutdownGracefully();
    }

    @Test
    public void testRunNonIoTasksSetupEventExecutor() {
        MockTicker ticker = Ticker.newMockTicker();
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(null, Thread.currentThread(), LocalIoHandler.newFactory(), (Ticker)ticker);
        org.junit.jupiter.api.Assertions.assertNull((Object)ThreadExecutorMap.currentExecutor());
        AtomicBoolean executed = new AtomicBoolean(false);
        eventLoop.execute(() -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)executed.compareAndSet(false, true));
            org.junit.jupiter.api.Assertions.assertSame((Object)eventLoop, (Object)ThreadExecutorMap.currentExecutor());
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)eventLoop.runNonBlockingTasks(0L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)executed.get());
        eventLoop.shutdownGracefully();
    }

    @ParameterizedTest
    @EnumSource(value=RunMode.class)
    public void testTasksWhileExpiringTimeout(RunMode mode) {
        MockTicker ticker = Ticker.newMockTicker();
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(null, Thread.currentThread(), LocalIoHandler.newFactory(), (Ticker)ticker);
        AtomicBoolean executedFirst = new AtomicBoolean(false);
        eventLoop.execute(() -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)executedFirst.compareAndSet(false, true));
            ticker.advance(1L, TimeUnit.NANOSECONDS);
        });
        AtomicBoolean canExecute = new AtomicBoolean(false);
        AtomicBoolean executedSecond = new AtomicBoolean(false);
        eventLoop.execute(() -> {
            if (!canExecute.get()) {
                org.junit.jupiter.api.Assertions.fail((String)"Should not be executed");
            } else {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)executedSecond.compareAndSet(false, true));
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)mode.runWith(eventLoop, 1L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)executedFirst.get());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)executedSecond.get());
        canExecute.set(true);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)mode.runWith(eventLoop, 1L));
        eventLoop.shutdownGracefully();
    }

    @Test
    public void testSetOwnerMultipleTimes() {
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(null, executor -> new TestIoHandler(new Semaphore(0)));
        eventLoop.setOwningThread(Thread.currentThread());
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> eventLoop.setOwningThread(Thread.currentThread()));
        eventLoop.shutdownGracefully();
    }

    @Test
    public void testTicker() {
        MockTicker ticker = Ticker.newMockTicker();
        ManualIoEventLoop eventLoop = new ManualIoEventLoop(null, Thread.currentThread(), NioIoHandler.newFactory(), (Ticker)ticker);
        AtomicInteger counter = new AtomicInteger();
        eventLoop.schedule(counter::incrementAndGet, 60L, TimeUnit.SECONDS);
        eventLoop.runNow();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)counter.get());
        ticker.advance(50L, TimeUnit.SECONDS);
        eventLoop.runNow();
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)counter.get());
        ticker.advance(20L, TimeUnit.SECONDS);
        eventLoop.runNow();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)counter.get());
        eventLoop.shutdownGracefully();
    }

    private static class TestIoHandler
    implements IoHandler {
        private final Semaphore semaphore;

        TestIoHandler(Semaphore semaphore) {
            this.semaphore = semaphore;
        }

        public void prepareToDestroy() {
        }

        public void destroy() {
        }

        public IoRegistration register(IoHandle handle) {
            return new IoRegistration(){
                private final AtomicBoolean canceled = new AtomicBoolean();

                public <T> T attachment() {
                    return null;
                }

                public long submit(IoOps ops) {
                    return 0L;
                }

                public boolean cancel() {
                    return this.canceled.compareAndSet(false, true);
                }

                public boolean isValid() {
                    return !this.canceled.get();
                }
            };
        }

        public void wakeup() {
            this.semaphore.release();
        }

        public int run(IoHandlerContext context) {
            try {
                if (context.canBlock() && context.deadlineNanos() != -1L) {
                    long delay = context.delayNanos(System.nanoTime());
                    this.semaphore.tryAcquire(delay, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return 0;
        }

        public boolean isCompatible(Class<? extends IoHandle> handleType) {
            return false;
        }
    }

    private static final class TestRunnable
    implements Runnable {
        private boolean done;

        private TestRunnable() {
        }

        @Override
        public void run() {
            this.done = true;
        }

        boolean isDone() {
            return this.done;
        }
    }

    private static enum RunMode {
        Now,
        Wait,
        NonIoNow;


        public int runWith(ManualIoEventLoop el, long timeoutNs) {
            switch (this) {
                case Now: {
                    return el.runNow(timeoutNs);
                }
                case Wait: {
                    return el.run(TimeUnit.HOURS.toNanos(1L), timeoutNs);
                }
                case NonIoNow: {
                    return el.runNonBlockingTasks(timeoutNs);
                }
            }
            throw new IllegalStateException("Unknown run mode: " + (Object)((Object)this));
        }
    }
}

