/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.IoEvent;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoEventLoopGroup;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerContext;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SingleThreadIoEventLoop;
import io.netty.util.concurrent.AutoScalingEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.ThreadAwareExecutor;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MultiThreadIoEventLoopGroupTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testScalingWithIoRegistrationLifecycle() throws InterruptedException {
        TestMultiThreadIoEventLoopGroup group = new TestMultiThreadIoEventLoopGroup(0, 2, 200L, TimeUnit.MILLISECONDS);
        try {
            MultiThreadIoEventLoopGroupTest.startAllExecutors(group);
            Assertions.assertEquals((int)2, (int)MultiThreadIoEventLoopGroupTest.countActiveExecutors(group));
            MultiThreadIoEventLoopGroupTest.waitForSuspension(group, 1, 2000L);
            Assertions.assertEquals((int)1, (int)MultiThreadIoEventLoopGroupTest.countActiveExecutors(group), (String)"One executor should have been suspended");
            TestableIoEventLoop activeExecutor = (TestableIoEventLoop)MultiThreadIoEventLoopGroupTest.findActiveExecutor(group);
            Assertions.assertNotNull((Object)((Object)activeExecutor), (String)"One executor should remain active");
            IoRegistration registration = (IoRegistration)activeExecutor.register(new TestIoHandle()).syncUninterruptibly().getNow();
            activeExecutor.setSimulateWorkload(true);
            Thread.sleep(450L);
            Assertions.assertFalse((boolean)activeExecutor.isSuspended(), (String)"Executor with active handle should not be suspended");
            activeExecutor.setSimulateWorkload(false);
            Assertions.assertTrue((boolean)registration.cancel());
            MultiThreadIoEventLoopGroupTest.waitForSuspension(group, 2, 2000L);
            Assertions.assertTrue((boolean)activeExecutor.isSuspended(), (String)"Executor should suspend after handle is cancelled and idle");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testShouldNotSuspendExecutorWithActiveRegistration() throws InterruptedException {
        TestMultiThreadIoEventLoopGroup group = new TestMultiThreadIoEventLoopGroup(0, 2, 200L, TimeUnit.MILLISECONDS);
        try {
            MultiThreadIoEventLoopGroupTest.startAllExecutors(group);
            MultiThreadIoEventLoopGroupTest.waitForSuspension(group, 1, 2000L);
            Assertions.assertEquals((int)1, (int)MultiThreadIoEventLoopGroupTest.countActiveExecutors(group), (String)"One executor should have been suspended");
            TestableIoEventLoop activeExecutor = (TestableIoEventLoop)MultiThreadIoEventLoopGroupTest.findActiveExecutor(group);
            Assertions.assertNotNull((Object)((Object)activeExecutor), (String)"One executor should remain active");
            IoRegistration registration = (IoRegistration)activeExecutor.register(new TestIoHandle()).syncUninterruptibly().getNow();
            activeExecutor.setSimulateWorkload(false);
            Thread.sleep(600L);
            Assertions.assertFalse((boolean)activeExecutor.isSuspended(), (String)"Executor with an active registration should not be suspended, even if idle");
            Assertions.assertEquals((int)1, (int)MultiThreadIoEventLoopGroupTest.countActiveExecutors(group), (String)"Only one executor should still be active");
            Assertions.assertTrue((boolean)registration.cancel());
            MultiThreadIoEventLoopGroupTest.waitForSuspension(group, 2, 2000L);
            Assertions.assertTrue((boolean)activeExecutor.isSuspended(), (String)"Executor should suspend after registration is cancelled and it remains idle");
        }
        finally {
            group.shutdownGracefully().syncUninterruptibly();
        }
    }

    private static void startAllExecutors(MultiThreadIoEventLoopGroup group) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(group.executorCount());
        for (EventExecutor executor : group) {
            executor.execute(latch::countDown);
        }
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS), (String)"Executors did not start in time");
    }

    private static int countActiveExecutors(MultiThreadIoEventLoopGroup group) {
        int activeCount = 0;
        for (EventExecutor executor : group) {
            if (executor.isSuspended()) continue;
            ++activeCount;
        }
        return activeCount;
    }

    private static EventExecutor findActiveExecutor(MultiThreadIoEventLoopGroup group) {
        for (EventExecutor executor : group) {
            if (executor.isSuspended()) continue;
            return executor;
        }
        return null;
    }

    private static void waitForSuspension(MultiThreadIoEventLoopGroup group, int expectedSuspendedCount, long timeoutMillis) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        while (System.currentTimeMillis() < deadline) {
            if (group.executorCount() - MultiThreadIoEventLoopGroupTest.countActiveExecutors(group) >= expectedSuspendedCount) {
                return;
            }
            Thread.sleep(50L);
        }
        Assertions.fail((String)("Timed out waiting for " + expectedSuspendedCount + " executor(s) to suspend."));
    }

    private static class TestMultiThreadIoEventLoopGroup
    extends MultiThreadIoEventLoopGroup {
        TestMultiThreadIoEventLoopGroup(int minThreads, int maxThreads, long checkPeriod, TimeUnit unit) {
            super(maxThreads, (Executor)null, (EventExecutorChooserFactory)new AutoScalingEventExecutorChooserFactory(minThreads, maxThreads, checkPeriod, unit, 0.4, 0.8, maxThreads, 1, 1), (IoHandlerFactory)new TestIoHandlerFactory());
        }

        protected IoEventLoop newChild(Executor executor, IoHandlerFactory ioHandlerFactory, Object ... args) {
            return new TestableIoEventLoop((IoEventLoopGroup)this, executor, ioHandlerFactory);
        }
    }

    private static class TestableIoEventLoop
    extends SingleThreadIoEventLoop {
        private final AtomicBoolean simulateWorkload = new AtomicBoolean(false);

        TestableIoEventLoop(IoEventLoopGroup parent, Executor executor, IoHandlerFactory ioHandlerFactory) {
            super(parent, executor, ioHandlerFactory);
        }

        public void setSimulateWorkload(boolean active) {
            this.simulateWorkload.set(active);
            if (active) {
                this.execute(() -> {});
            }
        }

        protected void run() {
            do {
                if (this.simulateWorkload.get()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    this.reportActiveIoTime(TimeUnit.MILLISECONDS.toNanos(100L));
                    continue;
                }
                Runnable task = this.takeTask();
                if (task == null) continue;
                TestableIoEventLoop.safeExecute((Runnable)task);
            } while (!this.confirmShutdown() && !this.canSuspend());
        }

        protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
            return new LinkedBlockingQueue<Runnable>(maxPendingTasks);
        }
    }

    private static class TestIoHandlerFactory
    implements IoHandlerFactory {
        private TestIoHandlerFactory() {
        }

        public IoHandler newHandler(ThreadAwareExecutor ioExecutor) {
            return new IoHandler(){

                public int run(IoHandlerContext context) {
                    return 0;
                }

                public void wakeup() {
                }

                public IoRegistration register(final IoHandle handle) {
                    return new IoRegistration(){
                        private final AtomicBoolean valid = new AtomicBoolean(true);

                        public <T> T attachment() {
                            return (T)handle;
                        }

                        public long submit(IoOps ops) {
                            return 0L;
                        }

                        public boolean isValid() {
                            return this.valid.get();
                        }

                        public boolean cancel() {
                            return this.valid.compareAndSet(true, false);
                        }
                    };
                }

                public boolean isCompatible(Class<? extends IoHandle> handleType) {
                    return true;
                }
            };
        }

        public boolean isChangingThreadSupported() {
            return true;
        }
    }

    private static class TestIoHandle
    implements IoHandle {
        private TestIoHandle() {
        }

        public void handle(IoRegistration registration, IoEvent readyOps) {
        }

        public void close() {
        }
    }
}

