/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerContext;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.nio.NioIoOps;
import io.netty.channel.nio.NioSelectableChannelIoHandle;
import io.netty.util.concurrent.ThreadAwareExecutor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NioIoHandlerTest {
    @Test
    void testNioHandlerCanBeDrivenByMainThread() throws Exception {
        IoHandlerFactory factory = NioIoHandler.newFactory();
        final Thread current = Thread.currentThread();
        final ConcurrentLinkedQueue tasks = new ConcurrentLinkedQueue();
        ThreadAwareExecutor executor = new ThreadAwareExecutor(){

            public boolean isExecutorThread(Thread thread) {
                return current == thread;
            }

            public void execute(Runnable command) {
                tasks.add(command);
            }
        };
        IoHandlerContext context = new IoHandlerContext(){

            public boolean canBlock() {
                return false;
            }

            public long delayNanos(long currentTimeNanos) {
                return 0L;
            }

            public long deadlineNanos() {
                return -1L;
            }
        };
        IoHandler handler = factory.newHandler(executor);
        final ServerSocketChannel channel = SelectorProvider.provider().openServerSocketChannel();
        channel.configureBlocking(false);
        channel.bind(new InetSocketAddress(0));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Socket socket = new Socket();
                try {
                    socket.connect(channel.getLocalAddress());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        final AtomicBoolean acceptedConnection = new AtomicBoolean();
        IoRegistration registration = handler.register((IoHandle)new NioSelectableChannelIoHandle<ServerSocketChannel>(channel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void handle(ServerSocketChannel channel, SelectionKey key) {
                if (key.isAcceptable()) {
                    try {
                        SocketChannel accepted = channel.accept();
                        accepted.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        acceptedConnection.set(true);
                    }
                }
            }
        });
        registration.submit((IoOps)NioIoOps.ACCEPT);
        t.start();
        while (registration.isValid()) {
            Runnable r;
            handler.run(context);
            while ((r = (Runnable)tasks.poll()) != null) {
                r.run();
            }
            if (!acceptedConnection.get()) continue;
            Assertions.assertTrue((boolean)registration.cancel());
        }
        t.join();
        channel.close();
        handler.prepareToDestroy();
        handler.destroy();
    }
}

