/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolTestUtils;
import io.netty.channel.pool.CountingChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class FixedChannelPoolTest {
    private static EventLoopGroup group;

    @BeforeAll
    public static void createEventLoop() {
        group = new DefaultEventLoopGroup();
    }

    @AfterAll
    public static void destroyEventLoop() {
        if (group != null) {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testAcquire() throws Exception {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)handler, 1, Integer.MAX_VALUE);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Future future = pool.acquire();
        Assertions.assertFalse((boolean)future.isDone());
        pool.release(channel).syncUninterruptibly();
        Assertions.assertTrue((boolean)future.await(1L, TimeUnit.SECONDS));
        Channel channel2 = (Channel)future.getNow();
        Assertions.assertSame((Object)channel, (Object)channel2);
        Assertions.assertEquals((int)1, (int)handler.channelCount());
        Assertions.assertEquals((int)2, (int)handler.acquiredCount());
        Assertions.assertEquals((int)1, (int)handler.releasedCount());
        sc.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireTimeout() throws Exception {
        this.testAcquireTimeout(500L);
    }

    @Test
    public void testAcquireWithZeroTimeout() throws Exception {
        this.testAcquireTimeout(0L);
    }

    private void testAcquireTimeout(long timeoutMillis) throws Exception {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, timeoutMillis, 1, Integer.MAX_VALUE);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        final Future future = pool.acquire();
        Assertions.assertThrows(TimeoutException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                future.syncUninterruptibly();
            }
        });
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireNewConnection() throws Exception {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.NEW, 500L, 1, Integer.MAX_VALUE);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertNotSame((Object)channel, (Object)channel2);
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireNewConnectionWhen() throws Exception {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)handler, 1);
        Channel channel1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        channel1.close().syncUninterruptibly();
        pool.release(channel1);
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertNotSame((Object)channel1, (Object)channel2);
        sc.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireBoundQueue() throws Exception {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)handler, 1, 1);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Future future = pool.acquire();
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable((ChannelPool)pool){
            final /* synthetic */ ChannelPool val$pool;
            {
                this.val$pool = channelPool;
            }

            public void execute() throws Throwable {
                this.val$pool.acquire().syncUninterruptibly();
            }
        });
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testReleaseDifferentPool() throws Exception {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)handler, 1, 1);
        FixedChannelPool pool2 = new FixedChannelPool(t.cb, (ChannelPoolHandler)handler, 1, 1);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable((ChannelPool)pool2, channel){
            final /* synthetic */ ChannelPool val$pool2;
            final /* synthetic */ Channel val$channel;
            {
                this.val$pool2 = channelPool;
                this.val$channel = channel;
            }

            public void execute() throws Throwable {
                this.val$pool2.release(this.val$channel).syncUninterruptibly();
            }
        });
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
        pool2.close();
    }

    @Test
    public void testReleaseAfterClosePool() throws Exception {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        final FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)new TestChannelPoolHandler(), 2);
        Future acquire = pool.acquire();
        final Channel channel = (Channel)acquire.get();
        pool.close();
        group.submit(new Runnable(){

            @Override
            public void run() {
            }
        }).syncUninterruptibly();
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                pool.release(channel).syncUninterruptibly();
            }
        });
        channel.closeFuture().syncUninterruptibly();
        Assertions.assertFalse((boolean)channel.isOpen());
        sc.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testReleaseClosed() {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)new TestChannelPoolHandler(), 2);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        channel.close().syncUninterruptibly();
        pool.release(channel).syncUninterruptibly();
        sc.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testCloseAsync() throws ExecutionException, InterruptedException {
        Tuple t = this.bootstrap();
        final Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        final FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)new TestChannelPoolHandler(), 2);
        pool.acquire().get();
        pool.acquire().get();
        final ChannelPromise closePromise = sc.newPromise();
        pool.closeAsync().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                Assertions.assertEquals((int)0, (int)pool.acquiredChannelCount());
                sc.close(closePromise).syncUninterruptibly();
            }
        }).awaitUninterruptibly();
        closePromise.awaitUninterruptibly();
    }

    @Test
    public void testChannelAcquiredException() throws InterruptedException {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        final NullPointerException exception = new NullPointerException();
        FixedChannelPool pool = new FixedChannelPool(t.cb, new ChannelPoolHandler(){

            public void channelReleased(Channel ch) {
            }

            public void channelAcquired(Channel ch) {
                throw exception;
            }

            public void channelCreated(Channel ch) {
            }
        }, 2);
        try {
            pool.acquire().sync();
        }
        catch (NullPointerException e) {
            Assertions.assertSame((Object)e, (Object)exception);
        }
        sc.close().sync();
        pool.close();
    }

    @Test
    public void testChannelReleaseHealthCheck() {
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        InnerFixedChannelPool pool = new InnerFixedChannelPool(t.cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.NEW, 500L, 1, Integer.MAX_VALUE, true);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        pool.release(channel).syncUninterruptibly().getNow();
        Channel sameChannel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertSame((Object)sameChannel, (Object)channel);
        sameChannel.close().syncUninterruptibly();
        pool.release(channel).syncUninterruptibly().getNow();
        sameChannel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertNotSame((Object)sameChannel, (Object)channel);
        sameChannel.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
        pool = new InnerFixedChannelPool(t.cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.NEW, 500L, 1, Integer.MAX_VALUE, false);
        channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        pool.release(channel).syncUninterruptibly().getNow();
        sameChannel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertSame((Object)sameChannel, (Object)channel);
        sameChannel.close().syncUninterruptibly();
        pool.release(channel).syncUninterruptibly().getNow();
        sameChannel = pool.pollChannel();
        Assertions.assertSame((Object)sameChannel, (Object)channel);
        sc.close().syncUninterruptibly();
        sameChannel.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testChannelProcessingOrder(boolean lastInFirstOutOrdering) {
        Channel channel;
        int i;
        Tuple t = this.bootstrap();
        Channel sc = t.sb.bind((SocketAddress)t.address).syncUninterruptibly().channel();
        FixedChannelPool pool = new FixedChannelPool(t.cb, (ChannelPoolHandler)new TestChannelPoolHandler(), ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.NEW, 500L, 1, Integer.MAX_VALUE, false, lastInFirstOutOrdering);
        int totalChannels = 5;
        ArrayList<Channel> channels = new ArrayList<Channel>();
        for (i = 0; i < totalChannels; ++i) {
            channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
            channels.add(channel);
        }
        for (i = 0; i < totalChannels; ++i) {
            pool.release((Channel)channels.get(i)).syncUninterruptibly().getNow();
        }
        for (i = 0; i < totalChannels; ++i) {
            channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
            if (lastInFirstOutOrdering) {
                Assertions.assertSame((Object)channel, channels.get(totalChannels - 1 - i));
                continue;
            }
            Assertions.assertSame((Object)channel, channels.get(i));
        }
        for (i = 0; i < totalChannels; ++i) {
            ((Channel)channels.get(i)).close().syncUninterruptibly();
            pool.release((Channel)channels.get(i)).syncUninterruptibly();
        }
        sc.close().syncUninterruptibly();
        pool.close();
    }

    private Tuple bootstrap() {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        return new Tuple(addr, cb, sb);
    }

    private static final class InnerFixedChannelPool
    extends FixedChannelPool {
        InnerFixedChannelPool(Bootstrap bootstrap, ChannelPoolHandler handler, ChannelHealthChecker healthCheck, FixedChannelPool.AcquireTimeoutAction action, long acquireTimeoutMillis, int maxConnections, int maxPendingAcquires, boolean releaseHealthCheck) {
            super(bootstrap, handler, healthCheck, action, acquireTimeoutMillis, maxConnections, maxPendingAcquires, releaseHealthCheck);
        }

        public Channel pollChannel() {
            return super.pollChannel();
        }
    }

    private static final class Tuple {
        LocalAddress address;
        Bootstrap cb;
        ServerBootstrap sb;

        Tuple(LocalAddress address, Bootstrap cb, ServerBootstrap sb) {
            this.address = address;
            this.cb = cb;
            this.sb = sb;
        }
    }

    private static final class TestChannelPoolHandler
    extends AbstractChannelPoolHandler {
        private TestChannelPoolHandler() {
        }

        public void channelCreated(Channel ch) throws Exception {
        }
    }
}

