/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.api.Buffer;
import io.netty5.util.Send;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public final class BufferInputStream
extends InputStream
implements DataInput {
    private final Buffer buffer;
    private final int startIndex;
    private final int endIndex;
    private boolean closed;
    private int markReaderOffset;
    private StringBuilder lineBuf;

    public BufferInputStream(Send<Buffer> buffer) {
        this.buffer = (Buffer)Objects.requireNonNull(buffer, "buffer").receive();
        int readableBytes = this.buffer.readableBytes();
        this.startIndex = this.buffer.readerOffset();
        this.endIndex = this.startIndex + readableBytes;
        this.markReaderOffset = this.startIndex;
    }

    public int readBytes() {
        return this.buffer.readerOffset() - this.startIndex;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try (Buffer buffer = this.buffer;){
            this.closed = true;
            super.close();
        }
    }

    @Override
    public int available() throws IOException {
        return Math.max(0, this.endIndex - this.buffer.readerOffset());
    }

    @Override
    public void mark(int readlimit) {
        this.markReaderOffset = this.buffer.readerOffset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkOpen();
        int available = this.available();
        if (available == 0) {
            return -1;
        }
        len = Math.min(available, len);
        this.buffer.readBytes(b, off, len);
        return len;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.readerOffset(this.markReaderOffset);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.skipBytes((int)Math.min(Integer.MAX_VALUE, n));
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.checkAvailable(1);
        return this.read() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int available = this.available();
        if (available == 0) {
            throw new EOFException();
        }
        return this.buffer.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.checkAvailable(len);
        this.buffer.readBytes(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        this.checkAvailable(4);
        return this.buffer.readInt();
    }

    @Override
    public String readLine() throws IOException {
        int available = this.available();
        if (available == 0) {
            return null;
        }
        if (this.lineBuf != null) {
            this.lineBuf.setLength(0);
        }
        block4: while (true) {
            int c = this.buffer.readUnsignedByte();
            --available;
            switch (c) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (available <= 0 || (char)this.buffer.getUnsignedByte(this.buffer.readerOffset()) != '\n') break block4;
                    this.buffer.skipReadableBytes(1);
                    break block4;
                }
                default: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new StringBuilder();
                    }
                    this.lineBuf.append((char)c);
                    if (available > 0) continue block4;
                }
            }
            break;
        }
        return this.lineBuf != null && this.lineBuf.length() > 0 ? this.lineBuf.toString() : "";
    }

    @Override
    public long readLong() throws IOException {
        this.checkAvailable(8);
        return this.buffer.readLong();
    }

    @Override
    public short readShort() throws IOException {
        this.checkAvailable(2);
        return this.buffer.readShort();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int nBytes = Math.min(this.available(), n);
        this.buffer.skipReadableBytes(nBytes);
        return nBytes;
    }

    Buffer buffer() {
        return this.buffer;
    }

    private void checkOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private void checkAvailable(int fieldSize) throws IOException {
        this.checkOpen();
        if (fieldSize < 0) {
            throw new IndexOutOfBoundsException("fieldSize cannot be a negative number");
        }
        if (fieldSize > this.available()) {
            throw new EOFException("fieldSize is too long! Length is " + fieldSize + ", but maximum is " + this.available());
        }
    }
}

