/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.api.Buffer;
import io.netty5.util.CharsetUtil;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public final class BufferOutputStream
extends OutputStream
implements DataOutput {
    private final Buffer buffer;
    private final int startIndex;
    private DataOutputStream utf8out;
    private boolean closed;

    public BufferOutputStream(Buffer buffer) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
        this.startIndex = buffer.writerOffset();
    }

    public int writtenBytes() {
        return this.buffer.writerOffset() - this.startIndex;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.prepareWrite(len);
        if (len > 0) {
            this.buffer.writeBytes(b, off, len);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.prepareWrite(b.length);
        if (b.length > 0) {
            this.buffer.writeBytes(b);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.prepareWrite(4);
        this.buffer.writeByte((byte)b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.prepareWrite(1);
        this.buffer.writeByte((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.prepareWrite(1);
        this.buffer.writeByte((byte)v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.prepareWrite(s.length());
        this.buffer.writeCharSequence(s, CharsetUtil.US_ASCII);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.prepareWrite(2);
        this.buffer.writeChar((char)v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        this.prepareWrite(len * 2);
        for (int i = 0; i < len; ++i) {
            this.buffer.writeChar(s.charAt(i));
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.prepareWrite(8);
        this.buffer.writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.prepareWrite(4);
        this.buffer.writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.prepareWrite(4);
        this.buffer.writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.prepareWrite(8);
        this.buffer.writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.prepareWrite(2);
        this.buffer.writeShort((short)v);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        DataOutputStream out = this.utf8out;
        if (out == null) {
            this.utf8out = out = new DataOutputStream(this);
        }
        out.writeUTF(s);
    }

    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            super.close();
        }
        finally {
            if (this.utf8out != null) {
                this.utf8out.close();
            }
        }
    }

    private void prepareWrite(int len) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (len > 0) {
            this.buffer.ensureWritable(len, this.buffer.capacity() >> 2, true);
        }
    }
}

