/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.DefaultBufferAllocators;
import io.netty5.buffer.api.internal.Statics;
import io.netty5.util.concurrent.FastThreadLocal;
import io.netty5.util.internal.MathUtil;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.StandardCharsets;

public final class BufferUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BufferUtil.class);
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;

    public static int reverseUnsignedShort(int value) {
        return Integer.reverseBytes(value) >>> 16;
    }

    public static int reverseMedium(int value) {
        return Integer.reverseBytes(value) >> 8;
    }

    public static int reverseUnsignedMedium(int value) {
        return Integer.reverseBytes(value) >>> 8;
    }

    public static long reverseUnsignedInt(long value) {
        return Long.reverseBytes(value) >>> 32;
    }

    public static String hexDump(Buffer buffer) {
        return BufferUtil.hexDump(buffer, buffer.readerOffset(), buffer.readableBytes());
    }

    public static String hexDump(Buffer buffer, int fromIndex, int length) {
        return HexUtil.hexDump(buffer, fromIndex, length);
    }

    public static String hexDump(byte[] array) {
        return BufferUtil.hexDump(array, 0, array.length);
    }

    public static String hexDump(byte[] array, int fromIndex, int length) {
        return HexUtil.hexDump(array, fromIndex, length);
    }

    public static Buffer writeAscii(BufferAllocator alloc, CharSequence seq) {
        return alloc.copyOf(seq.toString(), StandardCharsets.US_ASCII);
    }

    public static byte[] getBytes(Buffer buf) {
        return BufferUtil.getBytes(buf, buf.readerOffset(), buf.readableBytes());
    }

    public static byte[] getBytes(Buffer buf, int start, int length) {
        int capacity = buf.capacity();
        if (MathUtil.isOutOfBounds((int)start, (int)length, (int)capacity)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= start + length(" + length + ") <= buf.capacity(" + capacity + ")");
        }
        byte[] bytes = PlatformDependent.allocateUninitializedArray((int)length);
        buf.copyInto(start, bytes, 0, length);
        return bytes;
    }

    public static boolean equals(Buffer first, int firstReaderOffset, Buffer second, int secondReaderOffset, int length) {
        return Statics.equals(first, firstReaderOffset, second, secondReaderOffset, length);
    }

    public static void appendPrettyHexDump(StringBuilder dump, Buffer buf) {
        BufferUtil.appendPrettyHexDump(dump, buf, buf.readerOffset(), buf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder dump, Buffer buf, int offset, int length) {
        HexUtil.appendPrettyHexDump(dump, buf, offset, length);
    }

    public static Buffer threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        return (Buffer)ThreadLocalDirectBufferHolder.BUFFER.get();
    }

    private BufferUtil() {
    }

    static {
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty5.threadLocalDirectBufferSize", (int)0);
        logger.debug("-Dio.netty5.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt((String)"io.netty5.maxThreadLocalCharBufferSize", (int)16384);
        logger.debug("-Dio.netty5.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
    }

    private static final class ThreadLocalDirectBufferHolder {
        static final FastThreadLocal<Buffer> BUFFER = new FastThreadLocal<Buffer>(){

            protected Buffer initialValue() throws Exception {
                return DefaultBufferAllocators.offHeapAllocator().allocate(1024);
            }

            protected void onRemoval(Buffer value) throws Exception {
                if (value.isAccessible()) {
                    value.close();
                }
                super.onRemoval((Object)value);
            }
        };

        private ThreadLocalDirectBufferHolder() {
        }
    }

    private static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEXPADDING;
        private static final String[] HEXDUMP_ROWPREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTEPADDING;

        private HexUtil() {
        }

        private static String hexDump(Buffer buffer, int fromIndex, int length) {
            ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
            if (length == 0) {
                return "";
            }
            int endIndex = fromIndex + length;
            char[] buf = new char[length << 1];
            int srcIdx = fromIndex;
            int dstIdx = 0;
            while (srcIdx < endIndex) {
                System.arraycopy(HEXDUMP_TABLE, buffer.getUnsignedByte(srcIdx) << 1, buf, dstIdx, 2);
                ++srcIdx;
                dstIdx += 2;
            }
            return new String(buf);
        }

        private static String hexDump(byte[] array, int fromIndex, int length) {
            ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
            if (length == 0) {
                return "";
            }
            int endIndex = fromIndex + length;
            char[] buf = new char[length << 1];
            int srcIdx = fromIndex;
            int dstIdx = 0;
            while (srcIdx < endIndex) {
                System.arraycopy(HEXDUMP_TABLE, (array[srcIdx] & 0xFF) << 1, buf, dstIdx, 2);
                ++srcIdx;
                dstIdx += 2;
            }
            return new String(buf);
        }

        private static void appendPrettyHexDump(StringBuilder dump, Buffer buf, int offset, int length) {
            if (MathUtil.isOutOfBounds((int)offset, (int)length, (int)buf.capacity())) {
                throw new IndexOutOfBoundsException("expected: 0 <= offset(" + offset + ") <= offset + length(" + length + ") <= buf.capacity(" + buf.capacity() + ")");
            }
            if (length == 0) {
                return;
            }
            dump.append("         +-------------------------------------------------+" + StringUtil.NEWLINE + "         |  0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f |" + StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
            int fullRows = length >>> 4;
            int remainder = length & 0xF;
            for (int row = 0; row < fullRows; ++row) {
                int j;
                int rowStartIndex = (row << 4) + offset;
                HexUtil.appendHexDumpRowPrefix(dump, row, rowStartIndex);
                int rowEndIndex = rowStartIndex + 16;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[buf.getUnsignedByte(j)]);
                }
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
                }
                dump.append('|');
            }
            if (remainder != 0) {
                int j;
                int rowStartIndex = (fullRows << 4) + offset;
                HexUtil.appendHexDumpRowPrefix(dump, fullRows, rowStartIndex);
                int rowEndIndex = rowStartIndex + remainder;
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2HEX[buf.getUnsignedByte(j)]);
                }
                dump.append(HEXPADDING[remainder]);
                dump.append(" |");
                for (j = rowStartIndex; j < rowEndIndex; ++j) {
                    dump.append(BYTE2CHAR[buf.getUnsignedByte(j)]);
                }
                dump.append(BYTEPADDING[remainder]);
                dump.append('|');
            }
            dump.append(StringUtil.NEWLINE + "+--------+-------------------------------------------------+----------------+");
        }

        private static void appendHexDumpRowPrefix(StringBuilder dump, int row, int rowStartIndex) {
            if (row < HEXDUMP_ROWPREFIXES.length) {
                dump.append(HEXDUMP_ROWPREFIXES[row]);
            } else {
                dump.append(StringUtil.NEWLINE);
                dump.append(Long.toHexString((long)rowStartIndex & 0xFFFFFFFFL | 0x100000000L));
                dump.setCharAt(dump.length() - 9, '|');
                dump.append('|');
            }
        }

        static {
            int i;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEXPADDING = new String[16];
            HEXDUMP_ROWPREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTEPADDING = new String[16];
            char[] DIGITS = "0123456789abcdef".toCharArray();
            for (i = 0; i < 256; ++i) {
                HexUtil.HEXDUMP_TABLE[i << 1] = DIGITS[i >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(i << 1) + 1] = DIGITS[i & 0xF];
            }
            for (i = 0; i < HEXPADDING.length; ++i) {
                int padding = HEXPADDING.length - i;
                HexUtil.HEXPADDING[i] = "   ".repeat(padding);
            }
            for (i = 0; i < HEXDUMP_ROWPREFIXES.length; ++i) {
                StringBuilder buf = new StringBuilder(12);
                buf.append(StringUtil.NEWLINE);
                buf.append(Long.toHexString((long)(i << 4) & 0xFFFFFFFFL | 0x100000000L));
                buf.setCharAt(buf.length() - 9, '|');
                buf.append('|');
                HexUtil.HEXDUMP_ROWPREFIXES[i] = buf.toString();
            }
            for (i = 0; i < BYTE2HEX.length; ++i) {
                HexUtil.BYTE2HEX[i] = " " + StringUtil.byteToHexStringPadded((int)i);
            }
            for (i = 0; i < BYTEPADDING.length; ++i) {
                int padding = BYTEPADDING.length - i;
                HexUtil.BYTEPADDING[i] = " ".repeat(padding);
            }
            for (i = 0; i < BYTE2CHAR.length; ++i) {
                HexUtil.BYTE2CHAR[i] = i <= 31 || i >= 127 ? 46 : (char)i;
            }
        }
    }
}

