/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api;

import io.netty5.buffer.api.AllocationType;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.CompositeBuffer;
import io.netty5.buffer.api.DefaultCompositeBuffer;
import io.netty5.buffer.api.ManagedBufferAllocator;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.internal.Statics;
import io.netty5.buffer.api.pool.PooledBufferAllocator;
import io.netty5.util.SafeCloseable;
import io.netty5.util.Send;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.function.Supplier;

public interface BufferAllocator
extends SafeCloseable {
    public static BufferAllocator onHeapUnpooled() {
        return new ManagedBufferAllocator(MemoryManager.instance(), false);
    }

    public static BufferAllocator offHeapUnpooled() {
        return new ManagedBufferAllocator(MemoryManager.instance(), true);
    }

    public static BufferAllocator onHeapPooled() {
        return new PooledBufferAllocator(MemoryManager.instance(), false);
    }

    public static BufferAllocator offHeapPooled() {
        return new PooledBufferAllocator(MemoryManager.instance(), true);
    }

    public boolean isPooling();

    public AllocationType getAllocationType();

    public Buffer allocate(int var1);

    default public CompositeBuffer compose(Send<Buffer> send) {
        return DefaultCompositeBuffer.compose(this, Collections.singleton(send));
    }

    default public CompositeBuffer compose(Iterable<Send<Buffer>> sends) {
        return DefaultCompositeBuffer.compose(this, sends);
    }

    default public CompositeBuffer compose() {
        return DefaultCompositeBuffer.compose(this);
    }

    public Supplier<Buffer> constBufferSupplier(byte[] var1);

    default public Buffer copyOf(byte[] bytes) {
        return this.allocate(bytes.length).writeBytes(bytes);
    }

    default public Buffer copyOf(String str, Charset charset) {
        byte[] bytes = str.getBytes(charset);
        return this.allocate(bytes.length).writeBytes(bytes);
    }

    default public Buffer copyOf(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return this.allocate(0);
        }
        int bytesToCopy = buffer.remaining();
        Buffer copy = this.allocate(bytesToCopy);
        ByteBuffer duplicate = buffer.duplicate();
        copy.forEachWritable(0, (i, component) -> {
            ByteBuffer dest = component.writableBuffer();
            int length = Math.min(dest.capacity(), duplicate.remaining());
            Statics.bbput(dest, 0, duplicate, duplicate.position(), length);
            duplicate.position(length + duplicate.position());
            return true;
        });
        copy.skipWritableBytes(bytesToCopy);
        return copy;
    }

    public void close();
}

