/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api;

import io.netty5.buffer.api.LeakInfo;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.function.Consumer;

public final class LoggingLeakCallback
implements Consumer<LeakInfo> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(LoggingLeakCallback.class);
    private static final LoggingLeakCallback instance = new LoggingLeakCallback();

    public static LoggingLeakCallback getInstance() {
        return instance;
    }

    private LoggingLeakCallback() {
    }

    @Override
    public void accept(LeakInfo leakInfo) {
        if (logger.isErrorEnabled()) {
            String message = "LEAK: Object \"" + leakInfo.objectDescription() + "\" was not property closed before it was garbage collected. A life-cycle back-trace (if any) is attached as suppressed exceptions. See https://netty.io/wiki/reference-counted-objects.html for more information.";
            logger.error(message, (Throwable)LeakReport.reportFor(leakInfo));
        }
    }

    private static final class LeakReport
    extends Throwable {
        private static final long serialVersionUID = -1894217374238341652L;

        static LeakReport reportFor(LeakInfo info) {
            LeakReport report = new LeakReport();
            info.forEach(tracePoint -> report.addSuppressed(tracePoint.traceback()));
            return report;
        }

        private LeakReport() {
            super("Object life-cycle trace:", null, true, false);
        }
    }
}

