/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api;

import io.netty5.buffer.api.AllocationType;
import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.StandardAllocationTypes;
import io.netty5.buffer.api.internal.Statics;
import io.netty5.buffer.api.internal.WrappingAllocation;
import java.nio.charset.Charset;
import java.util.function.Supplier;

class ManagedBufferAllocator
implements BufferAllocator,
AllocatorControl {
    private final MemoryManager manager;
    private final AllocationType allocationType;
    private volatile boolean closed;

    ManagedBufferAllocator(MemoryManager manager, boolean direct) {
        this.manager = manager;
        this.allocationType = direct ? StandardAllocationTypes.OFF_HEAP : StandardAllocationTypes.ON_HEAP;
    }

    @Override
    public boolean isPooling() {
        return false;
    }

    @Override
    public AllocationType getAllocationType() {
        return this.allocationType;
    }

    @Override
    public Buffer allocate(int size) {
        if (this.closed) {
            throw Statics.allocatorClosedException();
        }
        Statics.assertValidBufferSize(size);
        return this.manager.allocateShared(this, size, Statics.standardDrop(this.manager), this.allocationType);
    }

    @Override
    public Supplier<Buffer> constBufferSupplier(byte[] bytes) {
        if (this.closed) {
            throw Statics.allocatorClosedException();
        }
        Buffer constantBuffer = this.manager.allocateShared(this, bytes.length, Statics.standardDrop(this.manager), this.allocationType);
        constantBuffer.writeBytes(bytes).makeReadOnly();
        return () -> this.manager.allocateConstChild(constantBuffer);
    }

    @Override
    public Buffer copyOf(String str, Charset charset) {
        if (!this.allocationType.isDirect()) {
            byte[] bytes = str.getBytes(charset);
            WrappingAllocation allocation = new WrappingAllocation(bytes);
            Buffer buffer = this.manager.allocateShared(this, bytes.length, Statics.standardDrop(this.manager), allocation);
            return buffer.writerOffset(bytes.length);
        }
        return BufferAllocator.super.copyOf(str, charset);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public BufferAllocator getAllocator() {
        return this;
    }
}

