/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api;

import io.netty5.buffer.api.AllocationType;
import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.LeakInfo;
import io.netty5.buffer.api.ManagedBufferAllocator;
import io.netty5.buffer.api.internal.ArcDrop;
import io.netty5.buffer.api.internal.LeakDetection;
import io.netty5.buffer.api.internal.MemoryManagerLoader;
import io.netty5.buffer.api.internal.MemoryManagerOverride;
import io.netty5.buffer.api.internal.WrappingAllocation;
import io.netty5.util.SafeCloseable;
import io.netty5.util.internal.UnstableApi;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

@UnstableApi
public interface MemoryManager {
    public static MemoryManager instance() {
        return MemoryManagerOverride.configuredOrDefaultManager();
    }

    @UnstableApi
    public static SafeCloseable onLeakDetected(Consumer<LeakInfo> callback) {
        return LeakDetection.onLeakDetected(callback);
    }

    public static <T> T using(MemoryManager manager, Supplier<T> supplier) {
        return MemoryManagerOverride.using(manager, supplier);
    }

    public static Stream<ServiceLoader.Provider<MemoryManager>> availableManagers() {
        return MemoryManagerLoader.stream();
    }

    public static Optional<MemoryManager> lookupImplementation(String implementationName) {
        return MemoryManager.availableManagers().flatMap(provider -> {
            try {
                return Stream.ofNullable((MemoryManager)provider.get());
            }
            catch (Exception | ServiceConfigurationError e) {
                InternalLogger logger = InternalLoggerFactory.getInstance(MemoryManager.class);
                if (logger.isTraceEnabled()) {
                    logger.debug("Failed to load a MemoryManager implementation.", e);
                } else {
                    logger.debug("Failed to load a MemoryManager implementation: " + e.getMessage());
                }
                return Stream.empty();
            }
        }).filter(impl -> implementationName.equals(impl.implementationName())).findFirst();
    }

    @UnstableApi
    public static Buffer unsafeWrap(byte[] array) {
        MemoryManager manager = MemoryManager.instance();
        ManagedBufferAllocator allocator = new ManagedBufferAllocator(manager, false);
        WrappingAllocation allocationType = new WrappingAllocation(array);
        Buffer buffer = manager.allocateShared(allocator, array.length, ArcDrop::wrap, allocationType);
        buffer.skipWritableBytes(array.length);
        return buffer.makeReadOnly();
    }

    public Buffer allocateShared(AllocatorControl var1, long var2, Function<Drop<Buffer>, Drop<Buffer>> var4, AllocationType var5);

    public Buffer allocateConstChild(Buffer var1);

    public Object unwrapRecoverableMemory(Buffer var1);

    public Buffer recoverMemory(AllocatorControl var1, Object var2, Drop<Buffer> var3);

    public Object sliceMemory(Object var1, int var2, int var3);

    public void clearMemory(Object var1);

    public String implementationName();
}

