/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api;

import io.netty5.buffer.api.AllocationType;
import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.StandardAllocationTypes;
import io.netty5.buffer.api.internal.ArcDrop;
import io.netty5.buffer.api.internal.CleanerDrop;
import io.netty5.buffer.api.internal.MemoryManagerOverride;
import java.util.function.Function;
import java.util.function.Supplier;

public final class SensitiveBufferAllocator
implements BufferAllocator {
    private static final BufferAllocator INSTANCE = new SensitiveBufferAllocator(null);
    private final AllocatorControl control = () -> this;
    private final Function<Drop<Buffer>, Drop<Buffer>> decorator = this::decorate;
    private final MemoryManager manager;

    public static BufferAllocator sensitiveOffHeapAllocator() {
        MemoryManager memoryManagerOverride = MemoryManagerOverride.configuredOrDefaultManager(null);
        if (memoryManagerOverride != null) {
            return new SensitiveBufferAllocator(memoryManagerOverride);
        }
        return INSTANCE;
    }

    private SensitiveBufferAllocator(MemoryManager manager) {
        this.manager = manager;
    }

    @Override
    public boolean isPooling() {
        return false;
    }

    @Override
    public AllocationType getAllocationType() {
        return StandardAllocationTypes.OFF_HEAP;
    }

    @Override
    public Buffer allocate(int size) {
        MemoryManager manager = this.getManager();
        return manager.allocateShared(this.control, size, this.decorator, this.getAllocationType());
    }

    private Drop<Buffer> decorate(Drop<Buffer> base) {
        MemoryManager manager = this.getManager();
        return CleanerDrop.wrap(ArcDrop.wrap(new ZeroingDrop(manager, this.control, base)), manager);
    }

    private MemoryManager getManager() {
        if (this.manager != null) {
            return MemoryManagerOverride.configuredOrDefaultManager(this.manager);
        }
        return MemoryManager.instance();
    }

    @Override
    public Supplier<Buffer> constBufferSupplier(byte[] bytes) {
        Buffer origin = this.copyOf(bytes).makeReadOnly();
        return () -> origin.copy(true);
    }

    @Override
    public void close() {
    }

    private static final class ZeroingDrop
    implements Drop<Buffer> {
        private final MemoryManager manager;
        private final Drop<Buffer> base;
        private final AllocatorControl control;

        ZeroingDrop(MemoryManager manager, AllocatorControl control, Drop<Buffer> base) {
            this.manager = manager;
            this.control = control;
            this.base = base;
        }

        @Override
        public void drop(Buffer obj) {
            Object memory = this.manager.unwrapRecoverableMemory(obj);
            this.manager.clearMemory(memory);
            this.base.drop(obj);
        }

        @Override
        public Drop<Buffer> fork() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void attach(Buffer obj) {
            this.base.attach(obj);
        }

        public String toString() {
            return "ZeroingDrop(" + this.base + ")";
        }
    }
}

