/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.bytebuffer;

import io.netty5.buffer.api.AllocationType;
import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.StandardAllocationTypes;
import io.netty5.buffer.api.bytebuffer.NioBuffer;
import io.netty5.buffer.api.internal.Statics;
import io.netty5.buffer.api.internal.WrappingAllocation;
import java.nio.ByteBuffer;
import java.util.function.Function;

public final class ByteBufferMemoryManager
implements MemoryManager {
    @Override
    public Buffer allocateShared(AllocatorControl allocatorControl, long size, Function<Drop<Buffer>, Drop<Buffer>> dropDecorator, AllocationType allocationType) {
        ByteBuffer buffer;
        int capacity = Math.toIntExact(size);
        if (allocationType == StandardAllocationTypes.OFF_HEAP) {
            buffer = ByteBuffer.allocateDirect(capacity);
        } else if (allocationType == StandardAllocationTypes.ON_HEAP) {
            buffer = ByteBuffer.allocate(capacity);
        } else if (allocationType instanceof WrappingAllocation) {
            buffer = ByteBuffer.wrap(((WrappingAllocation)allocationType).getArray());
        } else {
            throw new IllegalArgumentException("Unknown allocation type: " + allocationType);
        }
        return ByteBufferMemoryManager.createBuffer(buffer, allocatorControl, dropDecorator.apply(ByteBufferMemoryManager.drop()));
    }

    @Override
    public Buffer allocateConstChild(Buffer readOnlyConstParent) {
        NioBuffer buf = (NioBuffer)readOnlyConstParent;
        return buf.newConstChild();
    }

    private static Drop<Buffer> drop() {
        return Statics.NO_OP_DROP;
    }

    @Override
    public Object unwrapRecoverableMemory(Buffer buf) {
        return ((NioBuffer)buf).recoverable();
    }

    @Override
    public Buffer recoverMemory(AllocatorControl allocatorControl, Object recoverableMemory, Drop<Buffer> drop) {
        ByteBuffer memory = (ByteBuffer)recoverableMemory;
        return ByteBufferMemoryManager.createBuffer(memory, allocatorControl, drop);
    }

    private static NioBuffer createBuffer(ByteBuffer memory, AllocatorControl allocatorControl, Drop<Buffer> drop) {
        Drop<NioBuffer> concreteDrop = Statics.convert(drop);
        NioBuffer nioBuffer = new NioBuffer(memory, memory, allocatorControl, concreteDrop);
        concreteDrop.attach(nioBuffer);
        return nioBuffer;
    }

    @Override
    public Object sliceMemory(Object memory, int offset, int length) {
        ByteBuffer buffer = (ByteBuffer)memory;
        return Statics.bbslice(buffer, offset, length);
    }

    @Override
    public void clearMemory(Object memory) {
        ByteBuffer buffer = (ByteBuffer)memory;
        Statics.setMemory(buffer, buffer.capacity(), (byte)0);
    }

    @Override
    public String implementationName() {
        return "ByteBuffer";
    }
}

