/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.bytebuffer;

import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferClosedException;
import io.netty5.buffer.api.BufferReadOnlyException;
import io.netty5.buffer.api.ByteCursor;
import io.netty5.buffer.api.ComponentIterator;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.Owned;
import io.netty5.buffer.api.ReadableComponent;
import io.netty5.buffer.api.ReadableComponentProcessor;
import io.netty5.buffer.api.WritableComponent;
import io.netty5.buffer.api.WritableComponentProcessor;
import io.netty5.buffer.api.internal.AdaptableBuffer;
import io.netty5.buffer.api.internal.NotReadOnlyReadableComponent;
import io.netty5.buffer.api.internal.SingleComponentIterator;
import io.netty5.buffer.api.internal.Statics;
import io.netty5.util.Resource;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

final class NioBuffer
extends AdaptableBuffer<NioBuffer>
implements ReadableComponent,
WritableComponent,
NotReadOnlyReadableComponent,
ComponentIterator.Next {
    private static final ByteBuffer CLOSED_BUFFER = ByteBuffer.allocate(0);
    private ByteBuffer base;
    private ByteBuffer rmem;
    private ByteBuffer wmem;
    private int roff;
    private int woff;
    private int implicitCapacityLimit;

    NioBuffer(ByteBuffer base, ByteBuffer memory, AllocatorControl control, Drop<NioBuffer> drop) {
        super(drop, control);
        this.base = base;
        this.rmem = memory;
        this.wmem = memory;
        this.implicitCapacityLimit = 0x7FFFFFF7;
    }

    private NioBuffer(NioBuffer parent, Drop<NioBuffer> drop) {
        super(drop, parent.control);
        this.implicitCapacityLimit = parent.implicitCapacityLimit;
        this.base = parent.base;
        this.rmem = parent.rmem.duplicate();
        this.wmem = CLOSED_BUFFER;
        this.roff = parent.roff;
        this.woff = parent.woff;
    }

    public String toString() {
        return "Buffer[roff:" + this.roff + ", woff:" + this.woff + ", cap:" + this.rmem.capacity() + "]";
    }

    @Override
    protected RuntimeException createResourceClosedException() {
        return Statics.bufferIsClosed(this);
    }

    @Override
    public int capacity() {
        return this.rmem.capacity();
    }

    @Override
    public int readerOffset() {
        return this.roff;
    }

    @Override
    public Buffer readerOffset(int offset) {
        this.checkRead(offset, 0);
        this.roff = offset;
        return this;
    }

    @Override
    public int writerOffset() {
        return this.woff;
    }

    @Override
    public Buffer writerOffset(int offset) {
        if (this.readOnly()) {
            throw Statics.bufferIsReadOnly(this);
        }
        this.checkWrite(offset, 0, false);
        this.woff = offset;
        return this;
    }

    @Override
    public int readableBytes() {
        return super.readableBytes();
    }

    @Override
    public int writableBytes() {
        return super.writableBytes();
    }

    @Override
    public NioBuffer skipReadableBytes(int delta) {
        return (NioBuffer)super.skipReadableBytes(delta);
    }

    @Override
    public NioBuffer skipWritableBytes(int delta) {
        return (NioBuffer)super.skipWritableBytes(delta);
    }

    @Override
    public Buffer fill(byte value) {
        int capacity = this.capacity();
        this.checkSet(0, capacity);
        if (this.rmem == CLOSED_BUFFER) {
            throw this.bufferIsClosed();
        }
        ByteBuffer wmem = this.wmem;
        Statics.setMemory(wmem, capacity, value);
        return this;
    }

    private long nativeAddress() {
        return Statics.nativeAddressOfDirectByteBuffer(this.rmem);
    }

    @Override
    public Buffer makeReadOnly() {
        this.wmem = CLOSED_BUFFER;
        return this;
    }

    @Override
    public boolean readOnly() {
        return this.wmem == CLOSED_BUFFER && this.rmem != CLOSED_BUFFER;
    }

    @Override
    public boolean isDirect() {
        return this.rmem.isDirect();
    }

    @Override
    public Buffer implicitCapacityLimit(int limit) {
        Statics.checkImplicitCapacity(limit, this.capacity());
        this.implicitCapacityLimit = limit;
        return this;
    }

    @Override
    public int implicitCapacityLimit() {
        return this.implicitCapacityLimit;
    }

    @Override
    public Buffer copy(int offset, int length, boolean readOnly) {
        Statics.checkLength(length);
        this.checkGet(offset, length);
        if (readOnly && this.readOnly()) {
            NioBuffer copy = this.newConstChild();
            if (offset > 0 || length < this.capacity()) {
                copy.rmem = Statics.bbslice(copy.rmem, offset, length);
            }
            copy.roff = 0;
            copy.woff = length;
            return copy;
        }
        Buffer copy = this.control.getAllocator().allocate(length);
        try {
            this.copyInto(offset, copy, 0, length);
            copy.writerOffset(length);
            if (readOnly) {
                copy.makeReadOnly();
            }
            return copy;
        }
        catch (Throwable e) {
            copy.close();
            throw e;
        }
    }

    @Override
    public void copyInto(int srcPos, byte[] dest, int destPos, int length) {
        this.copyInto(srcPos, ByteBuffer.wrap(dest), destPos, length);
    }

    @Override
    public void copyInto(int srcPos, ByteBuffer dest, int destPos, int length) {
        if (this.rmem == CLOSED_BUFFER) {
            throw this.bufferIsClosed();
        }
        if (srcPos < 0) {
            throw new IndexOutOfBoundsException("The srcPos cannot be negative: " + srcPos + ".");
        }
        if (destPos < 0) {
            throw new IndexOutOfBoundsException("The destination position cannot be negative: " + destPos);
        }
        Statics.checkLength(length);
        if (this.capacity() < srcPos + length) {
            throw new IndexOutOfBoundsException("The srcPos + length is beyond the end of the buffer: srcPos = " + srcPos + ", length = " + length + ".");
        }
        if (dest.capacity() < destPos + length) {
            throw new IndexOutOfBoundsException("The destPos + length is beyond the end of the buffer: destPos = " + destPos + ", length = " + length + ".");
        }
        if (dest.hasArray() && this.hasReadableArray()) {
            byte[] srcArray = this.rmem.array();
            int srcStart = this.rmem.arrayOffset() + srcPos;
            byte[] dstArray = dest.array();
            int dstStart = dest.arrayOffset() + destPos;
            System.arraycopy(srcArray, srcStart, dstArray, dstStart, length);
            return;
        }
        dest = dest.duplicate().clear();
        Statics.bbput(dest, destPos, this.rmem, srcPos, length);
    }

    @Override
    public void copyInto(int srcPos, Buffer dest, int destPos, int length) {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (dest.readOnly()) {
            throw Statics.bufferIsReadOnly(dest);
        }
        if (dest instanceof NioBuffer) {
            NioBuffer nb = (NioBuffer)dest;
            nb.checkSet(destPos, length);
            this.copyInto(srcPos, nb.wmem, destPos, length);
            return;
        }
        Statics.copyToViaReverseLoop(this, srcPos, dest, destPos, length);
    }

    @Override
    public int transferTo(WritableByteChannel channel, int length) throws IOException {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        length = Math.min(this.readableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkGet(this.readerOffset(), length);
        int bytesWritten = channel.write(this.readableBuffer().limit(length));
        this.skipReadableBytes(bytesWritten);
        return bytesWritten;
    }

    @Override
    public int transferFrom(FileChannel channel, long position, int length) throws IOException {
        ObjectUtil.checkPositiveOrZero((long)position, (String)"position");
        ObjectUtil.checkPositiveOrZero((int)length, (String)"length");
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (this.readOnly()) {
            throw Statics.bufferIsReadOnly(this);
        }
        length = Math.min(this.writableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkSet(this.writerOffset(), length);
        int bytesRead = channel.read(this.writableBuffer().limit(length), position);
        if (bytesRead > 0) {
            this.skipWritableBytes(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int transferFrom(ReadableByteChannel channel, int length) throws IOException {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (this.readOnly()) {
            throw Statics.bufferIsReadOnly(this);
        }
        length = Math.min(this.writableBytes(), length);
        if (length == 0) {
            return 0;
        }
        this.checkSet(this.writerOffset(), length);
        int bytesRead = channel.read(this.writableBuffer().limit(length));
        if (bytesRead != -1) {
            this.skipWritableBytes(bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int bytesBefore(byte needle) {
        int offset;
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        int length = this.woff - this.roff;
        int end = this.woff;
        if (length > 7) {
            long pattern = ((long)needle & 0xFFL) * 0x101010101010101L;
            int longEnd = offset + (length >>> 3) * 8;
            for (offset = this.roff; offset < longEnd; offset += 8) {
                long word = this.rmem.getLong(offset);
                long input = word ^ pattern;
                long tmp = (input & 0x7F7F7F7F7F7F7F7FL) + 0x7F7F7F7F7F7F7F7FL;
                int binaryPosition = Long.numberOfLeadingZeros(tmp = (tmp | input | 0x7F7F7F7F7F7F7F7FL) ^ 0xFFFFFFFFFFFFFFFFL);
                int index = binaryPosition >>> 3;
                if (index >= 8) continue;
                return offset + index - this.roff;
            }
        }
        while (offset < end) {
            if (this.rmem.get(offset) == needle) {
                return offset - this.roff;
            }
            ++offset;
        }
        return -1;
    }

    @Override
    public int bytesBefore(Buffer needle) {
        Statics.UncheckedLoadByte uncheckedLoadByte = NioBuffer::uncheckedLoadByte;
        return Statics.bytesBefore(this, uncheckedLoadByte, needle, needle instanceof NioBuffer ? uncheckedLoadByte : null);
    }

    private static byte uncheckedLoadByte(Buffer buffer, int offset) {
        return ((NioBuffer)buffer).rmem.get(offset);
    }

    @Override
    public ByteCursor openCursor() {
        return this.openCursor(this.readerOffset(), this.readableBytes());
    }

    @Override
    public ByteCursor openCursor(int fromOffset, int length) {
        if (this.rmem == CLOSED_BUFFER) {
            throw this.bufferIsClosed();
        }
        if (fromOffset < 0) {
            throw new IndexOutOfBoundsException("The fromOffset cannot be negative: " + fromOffset + ".");
        }
        Statics.checkLength(length);
        if (this.capacity() < fromOffset + length) {
            throw new IndexOutOfBoundsException("The fromOffset + length is beyond the end of the buffer: fromOffset = " + fromOffset + ", length = " + length + ".");
        }
        return new ForwardNioByteCursor(this.rmem, fromOffset, length);
    }

    @Override
    public ByteCursor openReverseCursor(int fromOffset, int length) {
        if (this.rmem == CLOSED_BUFFER) {
            throw this.bufferIsClosed();
        }
        if (fromOffset < 0) {
            throw new IndexOutOfBoundsException("The fromOffset cannot be negative: " + fromOffset + ".");
        }
        Statics.checkLength(length);
        if (this.capacity() <= fromOffset) {
            throw new IndexOutOfBoundsException("The fromOffset is beyond the end of the buffer: " + fromOffset + ".");
        }
        if (fromOffset - length < -1) {
            throw new IndexOutOfBoundsException("The fromOffset - length would underflow the buffer: fromOffset = " + fromOffset + ", length = " + length + ".");
        }
        return new ReverseNioByteCursor(this.rmem, fromOffset, length);
    }

    @Override
    public Buffer ensureWritable(int size, int minimumGrowth, boolean allowCompaction) {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (!this.isOwned()) {
            throw this.attachTrace(new IllegalStateException("Buffer is not owned. Only owned buffers can call ensureWritable."));
        }
        if (size < 0) {
            throw new IllegalArgumentException("Cannot ensure writable for a negative size: " + size + ".");
        }
        if (minimumGrowth < 0) {
            throw new IllegalArgumentException("The minimum growth cannot be negative: " + minimumGrowth + ".");
        }
        if (this.rmem != this.wmem) {
            throw Statics.bufferIsReadOnly(this);
        }
        if (this.writableBytes() >= size) {
            return this;
        }
        if (allowCompaction && this.writableBytes() + this.readerOffset() >= size) {
            return this.compact();
        }
        long newSize = (long)this.capacity() + (long)Math.max(size - this.writableBytes(), minimumGrowth);
        Statics.assertValidBufferSize(newSize);
        NioBuffer buffer = (NioBuffer)this.control.getAllocator().allocate((int)newSize);
        this.copyInto(0, buffer, 0, this.capacity());
        Drop<NioBuffer> drop = buffer.unsafeGetDrop();
        this.disconnectDrop(drop);
        this.attachNewBuffer(buffer, drop);
        return this;
    }

    private void disconnectDrop(Drop<NioBuffer> newDrop) {
        Drop<NioBuffer> drop = this.unsafeGetDrop();
        int roff = this.roff;
        int woff = this.woff;
        drop.drop(this);
        this.unsafeSetDrop(newDrop);
        this.roff = roff;
        this.woff = woff;
    }

    private void attachNewBuffer(NioBuffer buffer, Drop<NioBuffer> drop) {
        this.base = buffer.base;
        this.rmem = buffer.rmem;
        this.wmem = buffer.wmem;
        drop.attach(this);
    }

    @Override
    public Buffer split(int splitOffset) {
        if (splitOffset < 0) {
            throw new IllegalArgumentException("The split offset cannot be negative: " + splitOffset + ".");
        }
        if (this.capacity() < splitOffset) {
            throw new IllegalArgumentException("The split offset cannot be greater than the buffer capacity, but the split offset was " + splitOffset + ", and capacity is " + this.capacity() + ".");
        }
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (!this.isOwned()) {
            throw this.attachTrace(new IllegalStateException("Cannot split a buffer that is not owned."));
        }
        Drop<NioBuffer> drop = this.unsafeGetDrop().fork();
        ByteBuffer splitByteBuffer = Statics.bbslice(this.rmem, 0, splitOffset);
        NioBuffer splitBuffer = new NioBuffer(this.base, splitByteBuffer, this.control, drop);
        drop.attach(splitBuffer);
        splitBuffer.woff = Math.min(this.woff, splitOffset);
        splitBuffer.roff = Math.min(this.roff, splitOffset);
        boolean readOnly = this.readOnly();
        if (readOnly) {
            splitBuffer.makeReadOnly();
        }
        this.rmem = Statics.bbslice(this.rmem, splitOffset, this.rmem.capacity() - splitOffset);
        if (!readOnly) {
            this.wmem = this.rmem;
        }
        this.woff = Math.max(this.woff, splitOffset) - splitOffset;
        this.roff = Math.max(this.roff, splitOffset) - splitOffset;
        return splitBuffer;
    }

    @Override
    public Buffer compact() {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        if (!this.isOwned()) {
            throw this.attachTrace(new IllegalStateException("Buffer must be owned in order to compact."));
        }
        if (this.readOnly()) {
            throw new BufferReadOnlyException("Buffer must be writable in order to compact, but was read-only.");
        }
        if (this.roff == 0) {
            return this;
        }
        this.rmem.limit(this.woff).position(this.roff).compact().clear();
        this.woff -= this.roff;
        this.roff = 0;
        return this;
    }

    @Override
    public int countComponents() {
        return 1;
    }

    @Override
    public int countReadableComponents() {
        return this.readableBytes() > 0 ? 1 : 0;
    }

    @Override
    public int countWritableComponents() {
        return this.writableBytes() > 0 ? 1 : 0;
    }

    @Override
    public boolean hasReadableArray() {
        return this.rmem.hasArray();
    }

    @Override
    public byte[] readableArray() {
        return this.rmem.array();
    }

    @Override
    public int readableArrayOffset() {
        return this.rmem.arrayOffset() + this.roff;
    }

    @Override
    public int readableArrayLength() {
        return this.woff - this.roff;
    }

    @Override
    public long readableNativeAddress() {
        return Statics.nativeAddressWithOffset(this.nativeAddress(), this.roff);
    }

    @Override
    public ByteBuffer readableBuffer() {
        return Statics.bbslice(this.rmem.asReadOnlyBuffer(), this.readerOffset(), this.readableBytes());
    }

    @Override
    public ByteBuffer mutableReadableBuffer() {
        return Statics.bbslice(this.rmem, this.readerOffset(), this.readableBytes());
    }

    @Override
    public boolean hasWritableArray() {
        return this.wmem.hasArray();
    }

    @Override
    public byte[] writableArray() {
        return this.wmem.array();
    }

    @Override
    public int writableArrayOffset() {
        return this.wmem.arrayOffset() + this.woff;
    }

    @Override
    public int writableArrayLength() {
        return this.capacity() - this.woff;
    }

    @Override
    public long writableNativeAddress() {
        return Statics.nativeAddressWithOffset(this.nativeAddress(), this.woff);
    }

    @Override
    public ByteBuffer writableBuffer() {
        return Statics.bbslice(this.wmem, this.writerOffset(), this.writableBytes());
    }

    @Override
    public <N extends ComponentIterator.Next> N next() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> int forEachReadable(int initialIndex, ReadableComponentProcessor<E> processor) throws E {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        int readableBytes = this.readableBytes();
        if (readableBytes == 0) {
            return 0;
        }
        this.checkRead(this.readerOffset(), readableBytes);
        try {
            int n = processor.process(initialIndex, this) ? 1 : -1;
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public <T extends ReadableComponent & ComponentIterator.Next> ComponentIterator<T> forEachReadable() {
        return new SingleComponentIterator((Resource<?>)this.acquire(), this.readableBytes() > 0 ? this : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> int forEachWritable(int initialIndex, WritableComponentProcessor<E> processor) throws E {
        if (!this.isAccessible()) {
            throw this.bufferIsClosed();
        }
        int writableBytes = this.writableBytes();
        if (writableBytes == 0) {
            return 0;
        }
        this.checkWrite(this.writerOffset(), writableBytes, false);
        try {
            int n = processor.process(initialIndex, this) ? 1 : -1;
            return n;
        }
        finally {
            Reference.reachabilityFence(this);
        }
    }

    @Override
    public <T extends WritableComponent & ComponentIterator.Next> ComponentIterator<T> forEachWritable() {
        this.checkWrite(this.writerOffset(), this.writableBytes(), false);
        return new SingleComponentIterator((Resource<?>)this.acquire(), this.writableBytes() > 0 ? this : null);
    }

    @Override
    public byte readByte() {
        this.checkRead(this.roff, 1);
        byte value = this.rmem.get(this.roff);
        ++this.roff;
        return value;
    }

    @Override
    public byte getByte(int roff) {
        this.checkGet(roff, 1);
        return this.rmem.get(roff);
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int getUnsignedByte(int roff) {
        return this.getByte(roff) & 0xFF;
    }

    @Override
    public Buffer writeByte(byte value) {
        this.checkWrite(this.woff, 1, true);
        try {
            this.wmem.put(this.woff, value);
            ++this.woff;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 1);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setByte(int woff, byte value) {
        try {
            this.wmem.put(woff, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 1);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer writeUnsignedByte(int value) {
        this.checkWrite(this.woff, 1, true);
        try {
            this.wmem.put(this.woff, (byte)(value & 0xFF));
            ++this.woff;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 1);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setUnsignedByte(int woff, int value) {
        try {
            this.wmem.put(woff, (byte)(value & 0xFF));
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 1);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public char readChar() {
        this.checkRead(this.roff, 2);
        char value = this.rmem.getChar(this.roff);
        this.roff += 2;
        return value;
    }

    @Override
    public char getChar(int roff) {
        this.checkGet(roff, 2);
        return this.rmem.getChar(roff);
    }

    @Override
    public Buffer writeChar(char value) {
        this.checkWrite(this.woff, 2, true);
        try {
            this.wmem.putChar(this.woff, value);
            this.woff += 2;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 2);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setChar(int woff, char value) {
        try {
            this.wmem.putChar(woff, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 2);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public short readShort() {
        this.checkRead(this.roff, 2);
        short value = this.rmem.getShort(this.roff);
        this.roff += 2;
        return value;
    }

    @Override
    public short getShort(int roff) {
        this.checkGet(roff, 2);
        return this.rmem.getShort(roff);
    }

    @Override
    public int readUnsignedShort() {
        this.checkRead(this.roff, 2);
        int value = this.rmem.getShort(this.roff) & 0xFFFF;
        this.roff += 2;
        return value;
    }

    @Override
    public int getUnsignedShort(int roff) {
        this.checkGet(roff, 2);
        return this.rmem.getShort(roff) & 0xFFFF;
    }

    @Override
    public Buffer writeShort(short value) {
        this.checkWrite(this.woff, 2, true);
        try {
            this.wmem.putShort(this.woff, value);
            this.woff += 2;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 2);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setShort(int woff, short value) {
        try {
            this.wmem.putShort(woff, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 2);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer writeUnsignedShort(int value) {
        this.checkWrite(this.woff, 2, true);
        try {
            this.wmem.putShort(this.woff, (short)(value & 0xFFFF));
            this.woff += 2;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 2);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setUnsignedShort(int woff, int value) {
        try {
            this.wmem.putShort(woff, (short)(value & 0xFFFF));
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 2);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public int readMedium() {
        this.checkRead(this.roff, 3);
        int value = this.rmem.get(this.roff) << 16 | (this.rmem.get(this.roff + 1) & 0xFF) << 8 | this.rmem.get(this.roff + 2) & 0xFF;
        this.roff += 3;
        return value;
    }

    @Override
    public int getMedium(int roff) {
        this.checkGet(roff, 3);
        return this.rmem.get(roff) << 16 | (this.rmem.get(roff + 1) & 0xFF) << 8 | this.rmem.get(roff + 2) & 0xFF;
    }

    @Override
    public int readUnsignedMedium() {
        this.checkRead(this.roff, 3);
        int value = (this.rmem.get(this.roff) << 16 | (this.rmem.get(this.roff + 1) & 0xFF) << 8 | this.rmem.get(this.roff + 2) & 0xFF) & 0xFFFFFF;
        this.roff += 3;
        return value;
    }

    @Override
    public int getUnsignedMedium(int roff) {
        this.checkGet(roff, 3);
        return (this.rmem.get(roff) << 16 | (this.rmem.get(roff + 1) & 0xFF) << 8 | this.rmem.get(roff + 2) & 0xFF) & 0xFFFFFF;
    }

    @Override
    public Buffer writeMedium(int value) {
        this.checkWrite(this.woff, 3, true);
        this.wmem.put(this.woff, (byte)(value >> 16));
        this.wmem.put(this.woff + 1, (byte)(value >> 8 & 0xFF));
        this.wmem.put(this.woff + 2, (byte)(value & 0xFF));
        this.woff += 3;
        return this;
    }

    @Override
    public Buffer setMedium(int woff, int value) {
        this.checkSet(woff, 3);
        this.wmem.put(woff, (byte)(value >> 16));
        this.wmem.put(woff + 1, (byte)(value >> 8 & 0xFF));
        this.wmem.put(woff + 2, (byte)(value & 0xFF));
        return this;
    }

    @Override
    public Buffer writeUnsignedMedium(int value) {
        this.checkWrite(this.woff, 3, true);
        this.wmem.put(this.woff, (byte)(value >> 16));
        this.wmem.put(this.woff + 1, (byte)(value >> 8 & 0xFF));
        this.wmem.put(this.woff + 2, (byte)(value & 0xFF));
        this.woff += 3;
        return this;
    }

    @Override
    public Buffer setUnsignedMedium(int woff, int value) {
        this.checkSet(woff, 3);
        this.wmem.put(woff, (byte)(value >> 16));
        this.wmem.put(woff + 1, (byte)(value >> 8 & 0xFF));
        this.wmem.put(woff + 2, (byte)(value & 0xFF));
        return this;
    }

    @Override
    public int readInt() {
        this.checkRead(this.roff, 4);
        int value = this.rmem.getInt(this.roff);
        this.roff += 4;
        return value;
    }

    @Override
    public int getInt(int roff) {
        this.checkGet(roff, 4);
        return this.rmem.getInt(roff);
    }

    @Override
    public long readUnsignedInt() {
        this.checkRead(this.roff, 4);
        long value = (long)this.rmem.getInt(this.roff) & 0xFFFFFFFFL;
        this.roff += 4;
        return value;
    }

    @Override
    public long getUnsignedInt(int roff) {
        this.checkGet(roff, 4);
        return (long)this.rmem.getInt(roff) & 0xFFFFFFFFL;
    }

    @Override
    public Buffer writeInt(int value) {
        this.checkWrite(this.woff, 4, true);
        try {
            this.wmem.putInt(this.woff, value);
            this.woff += 4;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 4);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setInt(int woff, int value) {
        try {
            this.wmem.putInt(woff, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 4);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer writeUnsignedInt(long value) {
        this.checkWrite(this.woff, 4, true);
        try {
            this.wmem.putInt(this.woff, (int)(value & 0xFFFFFFFFL));
            this.woff += 4;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 4);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setUnsignedInt(int woff, long value) {
        try {
            this.wmem.putInt(woff, (int)(value & 0xFFFFFFFFL));
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 4);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public float readFloat() {
        this.checkRead(this.roff, 4);
        float value = this.rmem.getFloat(this.roff);
        this.roff += 4;
        return value;
    }

    @Override
    public float getFloat(int roff) {
        this.checkGet(roff, 4);
        return this.rmem.getFloat(roff);
    }

    @Override
    public Buffer writeFloat(float value) {
        this.checkWrite(this.woff, 4, true);
        try {
            this.wmem.putFloat(this.woff, value);
            this.woff += 4;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 4);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setFloat(int woff, float value) {
        try {
            this.wmem.putFloat(woff, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 4);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public long readLong() {
        this.checkRead(this.roff, 8);
        long value = this.rmem.getLong(this.roff);
        this.roff += 8;
        return value;
    }

    @Override
    public long getLong(int roff) {
        this.checkGet(roff, 8);
        return this.rmem.getLong(roff);
    }

    @Override
    public Buffer writeLong(long value) {
        this.checkWrite(this.woff, 8, true);
        try {
            this.wmem.putLong(this.woff, value);
            this.woff += 8;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 8);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setLong(int woff, long value) {
        try {
            this.wmem.putLong(woff, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 8);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public double readDouble() {
        this.checkRead(this.roff, 8);
        double value = this.rmem.getDouble(this.roff);
        this.roff += 8;
        return value;
    }

    @Override
    public double getDouble(int roff) {
        this.checkGet(roff, 8);
        return this.rmem.getDouble(roff);
    }

    @Override
    public Buffer writeDouble(double value) {
        this.checkWrite(this.woff, 8, true);
        try {
            this.wmem.putDouble(this.woff, value);
            this.woff += 8;
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, this.woff, 8);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    public Buffer setDouble(int woff, double value) {
        try {
            this.wmem.putDouble(woff, value);
            return this;
        }
        catch (IndexOutOfBoundsException e) {
            throw this.checkWriteState(e, woff, 8);
        }
        catch (ReadOnlyBufferException e) {
            throw Statics.bufferIsReadOnly(this);
        }
    }

    @Override
    protected Owned<NioBuffer> prepareSend() {
        int roff = this.roff;
        int woff = this.woff;
        boolean readOnly = this.readOnly();
        int implicitCapacityLimit = this.implicitCapacityLimit;
        ByteBuffer base = this.base;
        ByteBuffer rmem = this.rmem;
        return drop -> {
            NioBuffer copy = new NioBuffer(base, rmem, this.control, drop);
            copy.roff = roff;
            copy.woff = woff;
            copy.implicitCapacityLimit = implicitCapacityLimit;
            if (readOnly) {
                copy.makeReadOnly();
            }
            return copy;
        };
    }

    @Override
    protected void makeInaccessible() {
        this.base = CLOSED_BUFFER;
        this.rmem = CLOSED_BUFFER;
        this.wmem = CLOSED_BUFFER;
        this.roff = 0;
        this.woff = 0;
    }

    private void checkRead(int index, int size) {
        if (index < 0 | this.woff < index + size) {
            throw this.readAccessCheckException(index, size);
        }
    }

    private void checkGet(int index, int size) {
        if (index < 0 | this.capacity() < index + size) {
            throw this.readAccessCheckException(index, size);
        }
    }

    private void checkWrite(int index, int size, boolean mayExpand) {
        if (index < this.roff | this.wmem.capacity() < index + size) {
            this.handleWriteAccessBoundsFailure(index, size, mayExpand);
        }
    }

    private void checkSet(int index, int size) {
        if (index < 0 | this.wmem.capacity() < index + size) {
            this.handleWriteAccessBoundsFailure(index, size, false);
        }
    }

    private RuntimeException checkWriteState(IndexOutOfBoundsException ioobe, int offset, int size) {
        if (this.rmem == CLOSED_BUFFER) {
            return this.bufferIsClosed();
        }
        if (this.wmem != this.rmem) {
            return Statics.bufferIsReadOnly(this);
        }
        IndexOutOfBoundsException exception = this.outOfBounds(offset, size);
        exception.addSuppressed(ioobe);
        return exception;
    }

    private RuntimeException readAccessCheckException(int index, int size) {
        if (this.rmem == CLOSED_BUFFER) {
            return this.bufferIsClosed();
        }
        return this.outOfBounds(index, size);
    }

    private void handleWriteAccessBoundsFailure(int index, int size, boolean mayExpand) {
        if (this.rmem == CLOSED_BUFFER) {
            throw this.bufferIsClosed();
        }
        if (this.wmem != this.rmem) {
            throw Statics.bufferIsReadOnly(this);
        }
        int capacity = this.capacity();
        if (mayExpand && index >= 0 && index <= capacity && this.woff + size <= this.implicitCapacityLimit && this.isOwned()) {
            int minimumGrowth = Math.min(Math.max(PlatformDependent.roundToPowerOfTwo((int)(capacity * 2)), size), this.implicitCapacityLimit) - capacity;
            this.ensureWritable(size, minimumGrowth, false);
            this.checkSet(index, size);
            return;
        }
        throw this.outOfBounds(index, size);
    }

    private BufferClosedException bufferIsClosed() {
        return this.attachTrace(Statics.bufferIsClosed(this));
    }

    private IndexOutOfBoundsException outOfBounds(int index, int size) {
        return new IndexOutOfBoundsException("Access at index " + index + " of size " + size + " is out of bounds: [read 0 to " + this.woff + ", write 0 to " + this.rmem.capacity() + "].");
    }

    ByteBuffer recoverable() {
        return this.base;
    }

    NioBuffer newConstChild() {
        assert (this.readOnly());
        Drop<NioBuffer> drop = this.unsafeGetDrop().fork();
        NioBuffer child = new NioBuffer(this, drop);
        drop.attach(child);
        return child;
    }

    private static final class ReverseNioByteCursor
    implements ByteCursor {
        final ByteBuffer buffer;
        int index;
        final int end;
        byte byteValue;

        ReverseNioByteCursor(ByteBuffer rmem, int fromOffset, int length) {
            this.buffer = rmem.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.index = fromOffset;
            this.end = this.index - length;
            this.byteValue = (byte)-1;
        }

        @Override
        public boolean readByte() {
            if (this.index > this.end) {
                this.byteValue = this.buffer.get(this.index);
                --this.index;
                return true;
            }
            return false;
        }

        @Override
        public byte getByte() {
            return this.byteValue;
        }

        @Override
        public int currentOffset() {
            return this.index;
        }

        @Override
        public int bytesLeft() {
            return this.index - this.end;
        }
    }

    private static final class ForwardNioByteCursor
    implements ByteCursor {
        final ByteBuffer buffer;
        int index;
        final int end;
        byte byteValue;

        ForwardNioByteCursor(ByteBuffer rmem, int fromOffset, int length) {
            this.buffer = rmem.duplicate().order(ByteOrder.BIG_ENDIAN);
            this.index = fromOffset;
            this.end = this.index + length;
            this.byteValue = (byte)-1;
        }

        @Override
        public boolean readByte() {
            if (this.index < this.end) {
                this.byteValue = this.buffer.get(this.index);
                ++this.index;
                return true;
            }
            return false;
        }

        @Override
        public byte getByte() {
            return this.byteValue;
        }

        @Override
        public int currentOffset() {
            return this.index;
        }

        @Override
        public int bytesLeft() {
            return this.end - this.index;
        }
    }
}

