/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.internal;

import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.internal.LeakDetection;
import io.netty5.buffer.api.internal.LifecycleTracer;
import io.netty5.buffer.api.internal.ResourceSupport;
import io.netty5.buffer.api.internal.Statics;
import java.lang.ref.Cleaner;
import java.util.concurrent.atomic.AtomicReference;

public final class CleanerDrop<T extends Buffer>
implements Drop<T> {
    private Cleaner.Cleanable cleanable;
    private GatedRunner<T> runner;

    public static <T extends Buffer> Drop<T> wrap(Drop<T> drop, MemoryManager manager) {
        return CleanerDrop.innerWrap(drop, manager);
    }

    private static <T extends Buffer> CleanerDrop<T> innerWrap(Drop<T> drop, MemoryManager manager) {
        CleanerDrop<T> cleanerDrop = new CleanerDrop<T>();
        GatedRunner<T> runner = new GatedRunner<T>(drop, manager);
        cleanerDrop.cleanable = Statics.CLEANER.register(cleanerDrop, runner);
        cleanerDrop.runner = runner;
        return cleanerDrop;
    }

    private CleanerDrop() {
    }

    @Override
    public void attach(T obj) {
        this.runner.prepareRecover(obj);
        this.runner.drop.attach(obj);
    }

    @Override
    public void drop(T obj) {
        this.runner.dropping = true;
        this.runner.set(obj);
        this.cleanable.clean();
    }

    @Override
    public Drop<T> fork() {
        CleanerDrop drop = CleanerDrop.innerWrap(this.runner.drop.fork(), this.runner.manager);
        drop.runner.tracerFromSplitParent = true;
        drop.runner.tracer = this.runner.tracer;
        return drop;
    }

    public String toString() {
        return "CleanerDrop(" + this.runner.drop + ")";
    }

    private static final class NoOpAllocatorControl
    implements AllocatorControl {
        private NoOpAllocatorControl() {
        }

        @Override
        public BufferAllocator getAllocator() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GatedRunner<T extends Buffer>
    extends AtomicReference<Object>
    implements Runnable {
        private static final NoOpAllocatorControl ALLOC_CONTROL = new NoOpAllocatorControl();
        private static final long serialVersionUID = 2685535951915798850L;
        final Drop<T> drop;
        final MemoryManager manager;
        volatile boolean dropping;
        volatile boolean tracerFromSplitParent;
        LifecycleTracer tracer;

        private GatedRunner(Drop<T> drop, MemoryManager manager) {
            this.drop = drop;
            this.manager = manager;
        }

        @Override
        public void run() {
            Object obj = this.getAndSet(null);
            if (obj != null) {
                if (this.dropping) {
                    this.drop.drop(obj);
                } else {
                    try (Buffer recoveredBuffer = this.manager.recoverMemory(ALLOC_CONTROL, obj, this.drop);){
                        LeakDetection.reportLeak(this.tracer, "buffer (" + recoveredBuffer.capacity() + " bytes)");
                    }
                }
            }
        }

        public void prepareRecover(T obj) {
            LifecycleTracer recoveredTracer = ResourceSupport.getTracer((ResourceSupport)obj);
            if (this.tracerFromSplitParent) {
                this.tracerFromSplitParent = false;
                this.tracer.splitTo(recoveredTracer);
            }
            this.tracer = recoveredTracer;
            this.set(this.manager.unwrapRecoverableMemory((Buffer)obj));
        }
    }
}

