/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.internal;

import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;

final class JniBufferAccess {
    static final boolean IS_AVAILABLE;
    static final MethodHandle MEMORY_ADDRESS;
    private static final InternalLogger logger;

    private JniBufferAccess() {
    }

    static {
        MethodType type;
        MethodHandles.Lookup lookup;
        Class<?> bufferAccess;
        logger = InternalLoggerFactory.getInstance(JniBufferAccess.class);
        boolean isAvailable = false;
        MethodHandle memoryAddress = null;
        try {
            bufferAccess = Class.forName("io.netty5.channel.unix.Buffer");
            lookup = MethodHandles.lookup();
            bufferAccess = lookup.accessClass(bufferAccess);
            type = MethodType.methodType(Long.TYPE, ByteBuffer.class);
            memoryAddress = lookup.findStatic(bufferAccess, "memoryAddress", type);
            isAvailable = true;
        }
        catch (Throwable e) {
            logger.debug("JNI unix bypass for accessing native address of DirectByteBuffer is unavailable.", e);
        }
        if (!isAvailable) {
            try {
                bufferAccess = Class.forName("io.netty.internal.tcnative.Buffer");
                lookup = MethodHandles.lookup();
                bufferAccess = lookup.accessClass(bufferAccess);
                type = MethodType.methodType(Long.TYPE, ByteBuffer.class);
                memoryAddress = lookup.findStatic(bufferAccess, "address", type);
                isAvailable = true;
            }
            catch (Throwable e) {
                logger.debug("JNI tcnative bypass for accessing native address of DirectByteBuffer is unavailable.", e);
            }
        }
        IS_AVAILABLE = isAvailable;
        MEMORY_ADDRESS = memoryAddress;
    }
}

