/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.internal;

import io.netty5.buffer.api.LeakInfo;
import io.netty5.buffer.api.Owned;
import io.netty5.buffer.api.internal.LeakDetection;
import io.netty5.buffer.api.internal.ResourceSupport;
import io.netty5.util.Resource;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

@UnstableApi
public abstract class LifecycleTracer {
    static final boolean lifecycleTracingEnabled = SystemPropertyUtil.getBoolean((String)"io.netty5.buffer.lifecycleTracingEnabled", (boolean)false);

    public static LifecycleTracer get() {
        if (!lifecycleTracingEnabled && LeakDetection.leakDetectionEnabled == 0) {
            return NoOpTracer.INSTANCE;
        }
        return new StackTracer();
    }

    public abstract void allocate();

    public abstract void acquire(int var1);

    public abstract void drop(int var1);

    public abstract void close(int var1);

    public abstract void touch(Object var1);

    public abstract <I extends Resource<I>, T extends ResourceSupport<I, T>> Owned<T> send(Owned<T> var1);

    public abstract void splitTo(LifecycleTracer var1);

    public abstract <E extends Throwable> E attachTrace(E var1);

    public abstract Collection<LeakInfo.TracePoint> collectTraces();

    private static enum AttachmentType {
        SEND_FROM,
        RECEIVED_AT,
        SPLIT_FROM,
        SPLIT_TO,
        HINT;

    }

    private static enum TraceType {
        ALLOCATE,
        ACQUIRE,
        CLOSE,
        DROP,
        SEND,
        RECEIVE,
        TOUCH,
        SPLIT;

    }

    private static final class Traceback
    extends Throwable {
        private static final long serialVersionUID = 941453986194634605L;

        Traceback(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static final class Trace
    implements Function<Stream<StackWalker.StackFrame>, Trace>,
    LeakInfo.TracePoint {
        private static final int TRACE_LIFECYCLE_DEPTH;
        public static final StackTraceElement[] EMPTY_TRACE;
        final TraceType type;
        final int acquires;
        final long timestamp;
        volatile AttachmentType attachmentType;
        volatile Object attachment;
        StackWalker.StackFrame[] frames;

        Trace(TraceType type) {
            this(type, Integer.MIN_VALUE);
        }

        Trace(TraceType type, int acquires) {
            this.type = type;
            this.acquires = acquires;
            this.timestamp = System.nanoTime();
        }

        @Override
        public Trace apply(Stream<StackWalker.StackFrame> frames) {
            this.frames = (StackWalker.StackFrame[])frames.skip(2L).limit(TRACE_LIFECYCLE_DEPTH + 1).toArray(StackWalker.StackFrame[]::new);
            return this;
        }

        public <E extends Throwable> void attach(E throwable, long timestamp) {
            Traceback exception = this.getTraceback(timestamp, true);
            throwable.addSuppressed(exception);
        }

        @Override
        public Throwable traceback() {
            return this.getTraceback(System.nanoTime(), true);
        }

        private Traceback getTraceback(long timestamp, boolean recurse) {
            Object message = this.type.name();
            Trace associatedTrace = this.getAssociatedTrace();
            message = this.explainAttachment((String)message, associatedTrace);
            if (this.acquires != Integer.MIN_VALUE) {
                message = (String)message + " (current acquires = " + this.acquires + ")";
            }
            message = (String)message + " T" + (this.timestamp - timestamp) / 1000L + "us.";
            Traceback exception = new Traceback((String)message);
            StackTraceElement[] stackTrace = this.framesToStackTrace();
            exception.setStackTrace(stackTrace);
            if (associatedTrace != null && recurse) {
                exception.addSuppressed(associatedTrace.getTraceback(timestamp, false));
            }
            return exception;
        }

        private Trace getAssociatedTrace() {
            Object associated = this.attachment;
            if (associated instanceof Trace) {
                return (Trace)associated;
            }
            return null;
        }

        private String explainAttachment(String message, Trace associatedTrace) {
            AttachmentType type = this.attachmentType;
            if (type == null) {
                return message;
            }
            switch (type) {
                case RECEIVED_AT: {
                    if (associatedTrace == null) {
                        message = (String)message + " (sent but not received)";
                        break;
                    }
                    message = (String)message + " (sent and received)";
                    break;
                }
                case SEND_FROM: {
                    message = (String)message + " (from a send)";
                    break;
                }
                case SPLIT_TO: {
                    message = (String)message + " (split into two)";
                    break;
                }
                case SPLIT_FROM: {
                    message = (String)message + " (split from other object)";
                    break;
                }
                case HINT: {
                    message = (String)message + " (" + this.attachment + ")";
                }
            }
            return message;
        }

        private StackTraceElement[] framesToStackTrace() {
            if (this.frames == null) {
                return EMPTY_TRACE;
            }
            StackTraceElement[] stackTrace = new StackTraceElement[this.frames.length];
            for (int i = 0; i < this.frames.length; ++i) {
                stackTrace[i] = this.frames[i].toStackTraceElement();
            }
            return stackTrace;
        }

        @Override
        public Object hint() {
            return this.attachmentType == AttachmentType.HINT ? this.attachment : null;
        }

        static {
            EMPTY_TRACE = new StackTraceElement[0];
            int traceDefault = 50;
            TRACE_LIFECYCLE_DEPTH = Math.max(Integer.getInteger("io.netty5.buffer.api.internal.LifecycleTracer.TRACE_LIFECYCLE_DEPTH", traceDefault), 0);
        }
    }

    private static final class StackTracer
    extends LifecycleTracer {
        private static final int MAX_TRACE_POINTS = Math.min(SystemPropertyUtil.getInt((String)"io.netty5.buffer.api.internal.LifecycleTracer.MAX_TRACE_POINTS", (int)50), 1000);
        private static final StackWalker WALKER;
        private final ArrayDeque<Trace> traces = new ArrayDeque();
        private boolean dropped;

        private StackTracer() {
        }

        @Override
        public void allocate() {
            this.addTrace(this.walk(new Trace(TraceType.ALLOCATE, 0)));
        }

        @Override
        public void acquire(int acquires) {
            this.addTrace(this.walk(new Trace(TraceType.ACQUIRE, acquires)));
        }

        @Override
        public void drop(int acquires) {
            this.dropped = true;
            this.addTrace(this.walk(new Trace(TraceType.DROP, acquires)));
        }

        @Override
        public void close(int acquires) {
            if (!this.dropped) {
                this.addTrace(this.walk(new Trace(TraceType.CLOSE, acquires)));
            }
        }

        @Override
        public void touch(Object hint) {
            Trace trace = new Trace(TraceType.TOUCH);
            trace.attachmentType = AttachmentType.HINT;
            trace.attachment = hint;
            this.addTrace(this.walk(trace));
        }

        @Override
        public <I extends Resource<I>, T extends ResourceSupport<I, T>> Owned<T> send(Owned<T> instance) {
            Trace sendTrace = new Trace(TraceType.SEND);
            sendTrace.attachmentType = AttachmentType.RECEIVED_AT;
            this.addTrace(this.walk(sendTrace));
            return drop -> {
                sendTrace.attachment = this.walk(new Trace(TraceType.RECEIVE));
                return (ResourceSupport)instance.transferOwnership(drop);
            };
        }

        @Override
        public void splitTo(LifecycleTracer splitTracer) {
            Trace splitParent = new Trace(TraceType.SPLIT);
            Trace splitChild = new Trace(TraceType.SPLIT);
            splitParent.attachmentType = AttachmentType.SPLIT_TO;
            splitParent.attachment = splitChild;
            splitChild.attachmentType = AttachmentType.SPLIT_FROM;
            splitChild.attachment = splitParent;
            this.addTrace(this.walk(splitParent));
            if (splitTracer instanceof StackTracer) {
                StackTracer tracer = (StackTracer)splitTracer;
                tracer.addTrace(this.walk(splitChild));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <E extends Throwable> E attachTrace(E throwable) {
            ArrayDeque<Trace> arrayDeque = this.traces;
            synchronized (arrayDeque) {
                long timestamp = System.nanoTime();
                for (Trace trace : this.traces) {
                    trace.attach(throwable, timestamp);
                }
            }
            return throwable;
        }

        @Override
        public Collection<LeakInfo.TracePoint> collectTraces() {
            return Collections.unmodifiableCollection(Collections.synchronizedCollection(this.traces));
        }

        Trace walk(Trace trace) {
            if (WALKER != null) {
                WALKER.walk(trace);
            }
            return trace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addTrace(Trace trace) {
            ArrayDeque<Trace> arrayDeque = this.traces;
            synchronized (arrayDeque) {
                if (this.traces.size() == MAX_TRACE_POINTS) {
                    this.traces.pollFirst();
                }
                this.traces.addLast(trace);
            }
        }

        static {
            int depth = Trace.TRACE_LIFECYCLE_DEPTH;
            WALKER = depth > 0 && lifecycleTracingEnabled ? StackWalker.getInstance(Set.of(), depth + 2) : null;
        }
    }

    private static final class NoOpTracer
    extends LifecycleTracer {
        private static final NoOpTracer INSTANCE = new NoOpTracer();

        private NoOpTracer() {
        }

        @Override
        public void allocate() {
        }

        @Override
        public void acquire(int acquires) {
        }

        @Override
        public void drop(int acquires) {
        }

        @Override
        public void close(int acquires) {
        }

        @Override
        public void touch(Object hint) {
        }

        @Override
        public <I extends Resource<I>, T extends ResourceSupport<I, T>> Owned<T> send(Owned<T> instance) {
            return instance;
        }

        @Override
        public void splitTo(LifecycleTracer splitTracer) {
        }

        @Override
        public <E extends Throwable> E attachTrace(E throwable) {
            return throwable;
        }

        @Override
        public Collection<LeakInfo.TracePoint> collectTraces() {
            return Collections.emptyList();
        }
    }
}

