/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.internal;

import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.bytebuffer.ByteBufferMemoryManager;
import io.netty5.buffer.api.unsafe.UnsafeMemoryManager;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public final class MemoryManagerOverride {
    private static final MemoryManager DEFAULT = MemoryManagerOverride.createDefaultMemoryManagerInstance();
    private static final AtomicInteger OVERRIDES_AVAILABLE = new AtomicInteger();
    private static final Map<Thread, MemoryManager> OVERRIDES = Collections.synchronizedMap(new IdentityHashMap());

    private MemoryManagerOverride() {
    }

    private static MemoryManager createDefaultMemoryManagerInstance() {
        String systemProperty = "io.netty5.buffer.api.MemoryManager";
        String configured = System.getProperty(systemProperty);
        InternalLogger logger = InternalLoggerFactory.getInstance(MemoryManagerOverride.class);
        if (configured != null) {
            Optional<MemoryManager> candidateManager = MemoryManager.lookupImplementation(configured);
            if (candidateManager.isPresent()) {
                logger.debug("{} configured: {}", (Object)systemProperty, (Object)configured);
                return candidateManager.get();
            }
            ByteBufferMemoryManager fallback = new ByteBufferMemoryManager();
            logger.debug("{} requested implementation is unavailable: {} (using default {} implementation instead)", new Object[]{systemProperty, configured, fallback.implementationName()});
            return fallback;
        }
        if (PlatformDependent.hasUnsafe() && PlatformDependent.hasDirectBufferNoCleanerConstructor()) {
            try {
                return new UnsafeMemoryManager();
            }
            catch (Exception exception) {
                logger.warn("Both sun.misc.Unsafe and DirectByteBuffer-without-Cleaner constructor are available, yet an UnsafeMemoryManager could not be created.", (Throwable)exception);
            }
        }
        return new ByteBufferMemoryManager();
    }

    public static MemoryManager configuredOrDefaultManager() {
        return MemoryManagerOverride.configuredOrDefaultManager(DEFAULT);
    }

    public static MemoryManager configuredOrDefaultManager(MemoryManager desiredDefault) {
        if (OVERRIDES_AVAILABLE.get() > 0) {
            return OVERRIDES.getOrDefault(Thread.currentThread(), desiredDefault);
        }
        return desiredDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T using(MemoryManager managers, Supplier<T> supplier) {
        Thread thread = Thread.currentThread();
        OVERRIDES.put(thread, managers);
        OVERRIDES_AVAILABLE.incrementAndGet();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            OVERRIDES_AVAILABLE.decrementAndGet();
            OVERRIDES.remove(thread);
        }
    }
}

