/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.pool;

import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.internal.ArcDrop;
import io.netty5.buffer.api.internal.CleanerDrop;
import io.netty5.buffer.api.internal.DropCaptor;
import io.netty5.buffer.api.pool.PoolArena;
import io.netty5.buffer.api.pool.PoolChunkList;
import io.netty5.buffer.api.pool.PoolChunkMetric;
import io.netty5.buffer.api.pool.PoolSubpage;
import io.netty5.buffer.api.pool.PoolThreadCache;
import io.netty5.buffer.api.pool.PooledDrop;
import io.netty5.buffer.api.pool.UntetheredMemory;
import io.netty5.util.internal.LongLongHashMap;
import io.netty5.util.internal.LongPriorityQueue;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.locks.ReentrantLock;

final class PoolChunk
implements PoolChunkMetric {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(PoolChunk.class);
    private static final int SIZE_BIT_LENGTH = 15;
    private static final int INUSED_BIT_LENGTH = 1;
    private static final int SUBPAGE_BIT_LENGTH = 1;
    private static final int BITMAP_IDX_BIT_LENGTH = 32;
    private static final AllocatorControl CONTROL = () -> {
        throw new AssertionError((Object)"PoolChunk base allocations should never need to access their allocator.");
    };
    static final int IS_SUBPAGE_SHIFT = 32;
    static final int IS_USED_SHIFT = 33;
    static final int SIZE_SHIFT = 34;
    static final int RUN_OFFSET_SHIFT = 49;
    final PoolArena arena;
    final Buffer base;
    final Object memory;
    final Drop<Buffer> baseDrop;
    private final LongLongHashMap runsAvailMap;
    private final LongPriorityQueue[] runsAvail;
    private final ReentrantLock runsAvailLock;
    private final PoolSubpage[] subpages;
    private final int pageSize;
    private final int pageShifts;
    private final int chunkSize;
    int freeBytes;
    int pinnedBytes;
    PoolChunkList parent;
    PoolChunk prev;
    PoolChunk next;

    PoolChunk(PoolArena arena, int pageSize, int pageShifts, int chunkSize, int maxPageIdx) {
        this.arena = arena;
        MemoryManager manager = arena.manager;
        DropCaptor dropCaptor = new DropCaptor();
        this.base = manager.allocateShared(CONTROL, chunkSize, drop -> dropCaptor.capture(ArcDrop.wrap(CleanerDrop.wrap(drop, manager))), arena.allocationType);
        this.baseDrop = dropCaptor.getDrop();
        this.memory = manager.unwrapRecoverableMemory(this.base);
        this.baseDrop.attach(this.base);
        this.pageSize = pageSize;
        this.pageShifts = pageShifts;
        this.chunkSize = chunkSize;
        this.freeBytes = chunkSize;
        this.runsAvail = PoolChunk.newRunsAvailqueueArray(maxPageIdx);
        this.runsAvailLock = new ReentrantLock();
        this.runsAvailMap = new LongLongHashMap(-1L);
        this.subpages = new PoolSubpage[chunkSize >> pageShifts];
        int pages = chunkSize >> pageShifts;
        long initHandle = (long)pages << 34;
        this.insertAvailRun(0, pages, initHandle);
    }

    private static LongPriorityQueue[] newRunsAvailqueueArray(int size) {
        LongPriorityQueue[] queueArray = new LongPriorityQueue[size];
        for (int i = 0; i < queueArray.length; ++i) {
            queueArray[i] = new LongPriorityQueue();
        }
        return queueArray;
    }

    private void insertAvailRun(int runOffset, int pages, long handle) {
        int pageIdxFloor = this.arena.pages2pageIdxFloor(pages);
        LongPriorityQueue queue = this.runsAvail[pageIdxFloor];
        queue.offer(handle);
        this.insertAvailRun0(runOffset, handle);
        if (pages > 1) {
            this.insertAvailRun0(PoolChunk.lastPage(runOffset, pages), handle);
        }
    }

    private void insertAvailRun0(int runOffset, long handle) {
        long pre = this.runsAvailMap.put((long)runOffset, handle);
        assert (pre == -1L);
    }

    private void removeAvailRun(long handle) {
        int pageIdxFloor = this.arena.pages2pageIdxFloor(PoolChunk.runPages(handle));
        LongPriorityQueue queue = this.runsAvail[pageIdxFloor];
        this.removeAvailRun(queue, handle);
    }

    private void removeAvailRun(LongPriorityQueue queue, long handle) {
        queue.remove(handle);
        int runOffset = PoolChunk.runOffset(handle);
        int pages = PoolChunk.runPages(handle);
        this.runsAvailMap.remove((long)runOffset);
        if (pages > 1) {
            this.runsAvailMap.remove((long)PoolChunk.lastPage(runOffset, pages));
        }
    }

    private static int lastPage(int runOffset, int pages) {
        return runOffset + pages - 1;
    }

    private long getAvailRunByOffset(int runOffset) {
        return this.runsAvailMap.get((long)runOffset);
    }

    @Override
    public int usage() {
        int freeBytes;
        this.arena.lock();
        try {
            freeBytes = this.freeBytes;
        }
        finally {
            this.arena.unlock();
        }
        return this.usage(freeBytes);
    }

    private int usage(int freeBytes) {
        if (freeBytes == 0) {
            return 100;
        }
        int freePercentage = (int)((long)freeBytes * 100L / (long)this.chunkSize);
        if (freePercentage == 0) {
            return 99;
        }
        return 100 - freePercentage;
    }

    UntetheredMemory allocate(int size, int sizeIdx, PoolThreadCache cache) {
        long handle;
        if (sizeIdx <= this.arena.smallMaxSizeIdx) {
            handle = this.allocateSubpage(sizeIdx);
            if (handle < 0L) {
                return null;
            }
            assert (PoolChunk.isSubpage(handle));
        } else {
            int runSize = this.arena.sizeIdx2size(sizeIdx);
            handle = this.allocateRun(runSize);
            if (handle < 0L) {
                return null;
            }
        }
        return this.allocateBuffer(handle, size, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateRun(int runSize) {
        int pages = runSize >> this.pageShifts;
        int pageIdx = this.arena.pages2pageIdx(pages);
        this.runsAvailLock.lock();
        try {
            int queueIdx = this.runFirstBestFit(pageIdx);
            if (queueIdx == -1) {
                long l = -1L;
                return l;
            }
            LongPriorityQueue queue = this.runsAvail[queueIdx];
            long handle = queue.poll();
            assert (handle != -1L && !PoolChunk.isUsed(handle)) : "invalid handle: " + handle;
            this.removeAvailRun(queue, handle);
            if (handle != -1L) {
                handle = this.splitLargeRun(handle, pages);
            }
            int pinnedSize = PoolChunk.runSize(this.pageShifts, handle);
            this.freeBytes -= pinnedSize;
            this.pinnedBytes += pinnedSize;
            long l = handle;
            return l;
        }
        finally {
            this.runsAvailLock.unlock();
        }
    }

    private int calculateRunSize(int sizeIdx) {
        int nElements;
        int maxElements = 1 << this.pageShifts - 4;
        int runSize = 0;
        int elemSize = this.arena.sizeIdx2size(sizeIdx);
        while ((nElements = (runSize += this.pageSize) / elemSize) < maxElements && runSize != nElements * elemSize) {
        }
        while (nElements > maxElements) {
            nElements = (runSize -= this.pageSize) / elemSize;
        }
        assert (nElements > 0);
        assert (runSize <= this.chunkSize);
        assert (runSize >= elemSize);
        return runSize;
    }

    private int runFirstBestFit(int pageIdx) {
        if (this.freeBytes == this.chunkSize) {
            return this.arena.nPSizes - 1;
        }
        for (int i = pageIdx; i < this.arena.nPSizes; ++i) {
            LongPriorityQueue queue = this.runsAvail[i];
            if (queue == null || queue.isEmpty()) continue;
            return i;
        }
        return -1;
    }

    private long splitLargeRun(long handle, int needPages) {
        assert (needPages > 0);
        int totalPages = PoolChunk.runPages(handle);
        assert (needPages <= totalPages);
        int remPages = totalPages - needPages;
        if (remPages > 0) {
            int runOffset = PoolChunk.runOffset(handle);
            int availOffset = runOffset + needPages;
            long availRun = PoolChunk.toRunHandle(availOffset, remPages, 0);
            this.insertAvailRun(availOffset, remPages, availRun);
            return PoolChunk.toRunHandle(runOffset, needPages, 1);
        }
        return handle |= 0x200000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allocateSubpage(int sizeIdx) {
        PoolSubpage head = this.arena.findSubpagePoolHead(sizeIdx);
        head.lock();
        try {
            PoolSubpage subpage;
            int runSize = this.calculateRunSize(sizeIdx);
            long runHandle = this.allocateRun(runSize);
            if (runHandle < 0L) {
                long l = -1L;
                return l;
            }
            int runOffset = PoolChunk.runOffset(runHandle);
            assert (this.subpages[runOffset] == null);
            int elemSize = this.arena.sizeIdx2size(sizeIdx);
            this.subpages[runOffset] = subpage = new PoolSubpage(head, this, this.pageShifts, runOffset, PoolChunk.runSize(this.pageShifts, runHandle), elemSize);
            long l = subpage.allocate();
            return l;
        }
        finally {
            head.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(long handle, int normCapacity) {
        int runSize = PoolChunk.runSize(this.pageShifts, handle);
        this.pinnedBytes -= runSize;
        if (PoolChunk.isSubpage(handle)) {
            int sizeIdx = this.arena.size2SizeIdx(normCapacity);
            PoolSubpage head = this.arena.findSubpagePoolHead(sizeIdx);
            int sIdx = PoolChunk.runOffset(handle);
            PoolSubpage subpage = this.subpages[sIdx];
            assert (subpage != null && subpage.doNotDestroy);
            head.lock();
            try {
                if (subpage.free(head, PoolChunk.bitmapIdx(handle))) {
                    return;
                }
                assert (!subpage.doNotDestroy);
                this.subpages[sIdx] = null;
            }
            finally {
                head.unlock();
            }
        }
        this.runsAvailLock.lock();
        try {
            long finalRun = this.collapseRuns(handle);
            finalRun &= 0xFFFFFFFDFFFFFFFFL;
            this.insertAvailRun(PoolChunk.runOffset(finalRun &= 0xFFFFFFFEFFFFFFFFL), PoolChunk.runPages(finalRun), finalRun);
            this.freeBytes += runSize;
        }
        finally {
            this.runsAvailLock.unlock();
        }
    }

    private long collapseRuns(long handle) {
        return this.collapseNext(this.collapsePast(handle));
    }

    private long collapsePast(long handle) {
        while (true) {
            int runOffset = PoolChunk.runOffset(handle);
            int runPages = PoolChunk.runPages(handle);
            long pastRun = this.getAvailRunByOffset(runOffset - 1);
            if (pastRun == -1L) {
                return handle;
            }
            int pastOffset = PoolChunk.runOffset(pastRun);
            int pastPages = PoolChunk.runPages(pastRun);
            if (pastRun == handle || pastOffset + pastPages != runOffset) break;
            this.removeAvailRun(pastRun);
            handle = PoolChunk.toRunHandle(pastOffset, pastPages + runPages, 0);
        }
        return handle;
    }

    private long collapseNext(long handle) {
        while (true) {
            int runPages;
            int runOffset;
            long nextRun;
            if ((nextRun = this.getAvailRunByOffset((runOffset = PoolChunk.runOffset(handle)) + (runPages = PoolChunk.runPages(handle)))) == -1L) {
                return handle;
            }
            int nextOffset = PoolChunk.runOffset(nextRun);
            int nextPages = PoolChunk.runPages(nextRun);
            if (nextRun == handle || runOffset + runPages != nextOffset) break;
            this.removeAvailRun(nextRun);
            handle = PoolChunk.toRunHandle(runOffset, runPages + nextPages, 0);
        }
        return handle;
    }

    private static long toRunHandle(int runOffset, int runPages, int inUsed) {
        return (long)runOffset << 49 | (long)runPages << 34 | (long)inUsed << 33;
    }

    UntetheredMemory allocateBuffer(long handle, int size, PoolThreadCache threadCache) {
        if (PoolChunk.isSubpage(handle)) {
            return this.allocateBufferWithSubpage(handle, size, threadCache);
        }
        int offset = PoolChunk.runOffset(handle) << this.pageShifts;
        int maxLength = PoolChunk.runSize(this.pageShifts, handle);
        PoolThreadCache poolThreadCache = this.arena.parent.threadCache();
        return new UntetheredChunkAllocation(this.memory, this, poolThreadCache, handle, maxLength, offset, size);
    }

    UntetheredMemory allocateBufferWithSubpage(long handle, int size, PoolThreadCache threadCache) {
        int runOffset = PoolChunk.runOffset(handle);
        int bitmapIdx = PoolChunk.bitmapIdx(handle);
        PoolSubpage s = this.subpages[runOffset];
        assert (s.doNotDestroy);
        assert (size <= s.elemSize) : size + "<=" + s.elemSize;
        int offset = (runOffset << this.pageShifts) + bitmapIdx * s.elemSize;
        return new UntetheredChunkAllocation(this.memory, this, threadCache, handle, s.elemSize, offset, size);
    }

    @Override
    public int chunkSize() {
        return this.chunkSize;
    }

    @Override
    public int freeBytes() {
        this.arena.lock();
        try {
            int n = this.freeBytes;
            return n;
        }
        finally {
            this.arena.unlock();
        }
    }

    @Override
    public int pinnedBytes() {
        this.arena.lock();
        try {
            int n = this.pinnedBytes;
            return n;
        }
        finally {
            this.arena.unlock();
        }
    }

    public String toString() {
        int freeBytes;
        this.arena.lock();
        try {
            freeBytes = this.freeBytes;
        }
        finally {
            this.arena.unlock();
        }
        return "Chunk(" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.usage(freeBytes) + "%, " + (this.chunkSize - freeBytes) + '/' + this.chunkSize + ')';
    }

    void destroy() {
        this.baseDrop.drop(this.base);
    }

    static int runOffset(long handle) {
        return (int)(handle >> 49);
    }

    static int runSize(int pageShifts, long handle) {
        return PoolChunk.runPages(handle) << pageShifts;
    }

    static int runPages(long handle) {
        return (int)(handle >> 34 & 0x7FFFL);
    }

    static boolean isUsed(long handle) {
        return (handle >> 33 & 1L) == 1L;
    }

    static boolean isSubpage(long handle) {
        return (handle >> 32 & 1L) == 1L;
    }

    static int bitmapIdx(long handle) {
        return (int)handle;
    }

    private static final class UntetheredChunkAllocation
    implements UntetheredMemory {
        private final Object memory;
        private final PoolChunk chunk;
        private final PoolThreadCache threadCache;
        private final long handle;
        private final int maxLength;

        private UntetheredChunkAllocation(Object memory, PoolChunk chunk, PoolThreadCache threadCache, long handle, int maxLength, int offset, int size) {
            try {
                this.memory = chunk.arena.manager.sliceMemory(memory, offset, size);
            }
            catch (Exception e) {
                LOGGER.error("Failed to create slice of pool chunk memory. Chunk layout: " + chunk.toString() + ", memory: " + chunk.memory, (Throwable)e);
                throw e;
            }
            this.chunk = chunk;
            this.threadCache = threadCache;
            this.handle = handle;
            this.maxLength = maxLength;
        }

        @Override
        public <Memory> Memory memory() {
            return (Memory)this.memory;
        }

        @Override
        public <BufferType extends Buffer> Drop<BufferType> drop() {
            Drop<Buffer> pooledDrop = ArcDrop.wrap(new PooledDrop(this.chunk, this.threadCache, this.handle, this.maxLength));
            return CleanerDrop.wrap(pooledDrop, this.chunk.arena.manager);
        }
    }
}

