/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.pool;

import io.netty5.buffer.api.AllocationType;
import io.netty5.buffer.api.AllocatorControl;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.StandardAllocationTypes;
import io.netty5.buffer.api.internal.ArcDrop;
import io.netty5.buffer.api.internal.Statics;
import io.netty5.buffer.api.pool.BufferAllocatorMetric;
import io.netty5.buffer.api.pool.BufferAllocatorMetricProvider;
import io.netty5.buffer.api.pool.PoolArena;
import io.netty5.buffer.api.pool.PoolArenaMetric;
import io.netty5.buffer.api.pool.PoolThreadCache;
import io.netty5.buffer.api.pool.PooledBufferAllocatorMetric;
import io.netty5.buffer.api.pool.UnpooledUntetheredMemory;
import io.netty5.buffer.api.pool.UntetheredMemory;
import io.netty5.util.NettyRuntime;
import io.netty5.util.concurrent.EventExecutor;
import io.netty5.util.concurrent.FastThreadLocal;
import io.netty5.util.concurrent.FastThreadLocalThread;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.SystemPropertyUtil;
import io.netty5.util.internal.ThreadExecutorMap;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class PooledBufferAllocator
implements BufferAllocator,
BufferAllocatorMetricProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledBufferAllocator.class);
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final long DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    static final int DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    private final Runnable trimTask = this::trimCurrentThreadCache;
    private final AllocatorControl pooledAllocatorControl = () -> this;
    private final MemoryManager manager;
    private final AllocationType allocationType;
    private final PoolArena[] arenas;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> arenaMetrics;
    private final List<PoolArenaMetric> arenaMetricsView;
    private final PoolThreadLocalCache threadCache;
    private final int chunkSize;
    private final PooledBufferAllocatorMetric metric;
    private volatile boolean closed;

    public PooledBufferAllocator(MemoryManager manager, boolean direct) {
        this(manager, direct, direct ? DEFAULT_NUM_DIRECT_ARENA : DEFAULT_NUM_HEAP_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledBufferAllocator(MemoryManager manager, boolean direct, int numArenas, int pageSize, int maxOrder) {
        this(manager, direct, numArenas, pageSize, maxOrder, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledBufferAllocator(MemoryManager manager, boolean direct, int numArenas, int pageSize, int maxOrder, int smallCacheSize, int normalCacheSize, boolean useCacheForAllThreads) {
        this(manager, direct, numArenas, pageSize, maxOrder, smallCacheSize, normalCacheSize, useCacheForAllThreads, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    public PooledBufferAllocator(MemoryManager manager, boolean direct, int numArenas, int pageSize, int maxOrder, int smallCacheSize, int normalCacheSize, boolean useCacheForAllThreads, int directMemoryCacheAlignment) {
        this.manager = Objects.requireNonNull(manager, "MemoryManager");
        this.allocationType = direct ? StandardAllocationTypes.OFF_HEAP : StandardAllocationTypes.ON_HEAP;
        this.threadCache = new PoolThreadLocalCache(useCacheForAllThreads);
        this.smallCacheSize = smallCacheSize;
        this.normalCacheSize = normalCacheSize;
        if (directMemoryCacheAlignment != 0) {
            if (!PlatformDependent.hasAlignDirectByteBuffer()) {
                throw new UnsupportedOperationException("Buffer alignment is not supported. Either Unsafe or ByteBuffer.alignSlice() must be available.");
            }
            pageSize = (int)PlatformDependent.align((long)pageSize, (int)directMemoryCacheAlignment);
        }
        this.chunkSize = PooledBufferAllocator.validateAndCalculateChunkSize(pageSize, maxOrder);
        ObjectUtil.checkPositiveOrZero((int)numArenas, (String)"numArenas");
        ObjectUtil.checkPositiveOrZero((int)directMemoryCacheAlignment, (String)"directMemoryCacheAlignment");
        if (directMemoryCacheAlignment > 0 && !PooledBufferAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        if ((directMemoryCacheAlignment & -directMemoryCacheAlignment) != directMemoryCacheAlignment) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + directMemoryCacheAlignment + " (expected: power of two)");
        }
        int pageShifts = PooledBufferAllocator.validateAndCalculatePageShifts(pageSize, directMemoryCacheAlignment);
        if (numArenas > 0) {
            this.arenas = PooledBufferAllocator.newArenaArray(numArenas);
            ArrayList<PoolArenaMetric> metrics = new ArrayList<PoolArenaMetric>(this.arenas.length);
            for (int i = 0; i < this.arenas.length; ++i) {
                PoolArena arena;
                this.arenas[i] = arena = new PoolArena(this, manager, this.allocationType, pageSize, pageShifts, this.chunkSize, directMemoryCacheAlignment);
                metrics.add(arena);
            }
            this.arenaMetrics = metrics;
            this.arenaMetricsView = Collections.unmodifiableList(metrics);
        } else {
            this.arenas = null;
            this.arenaMetrics = new ArrayList<PoolArenaMetric>(1);
            this.arenaMetricsView = Collections.emptyList();
        }
        this.metric = new PooledBufferAllocatorMetric(this);
    }

    final AllocatorControl getPooledAllocatorControl() {
        return this.pooledAllocatorControl;
    }

    private static PoolArena[] newArenaArray(int size) {
        return new PoolArena[size];
    }

    private static int validateAndCalculatePageShifts(int pageSize, int alignment) {
        if (pageSize < 4096) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: 4096)");
        }
        if ((pageSize & pageSize - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + pageSize + " (expected: power of 2)");
        }
        if (pageSize < alignment) {
            throw new IllegalArgumentException("Alignment cannot be greater than page size. Alignment: " + alignment + ", page size: " + pageSize + ".");
        }
        return 31 - Integer.numberOfLeadingZeros(pageSize);
    }

    private static int validateAndCalculateChunkSize(int pageSize, int maxOrder) {
        if (maxOrder > 14) {
            throw new IllegalArgumentException("maxOrder: " + maxOrder + " (expected: 0-14)");
        }
        int chunkSize = pageSize;
        for (int i = maxOrder; i > 0; --i) {
            if (chunkSize > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", pageSize, maxOrder, 0x40000000));
            }
            chunkSize <<= 1;
        }
        return chunkSize;
    }

    @Override
    public boolean isPooling() {
        return true;
    }

    @Override
    public AllocationType getAllocationType() {
        return this.allocationType;
    }

    @Override
    public Buffer allocate(int size) {
        if (this.closed) {
            throw Statics.allocatorClosedException();
        }
        Statics.assertValidBufferSize(size);
        UntetheredMemory memory = this.allocateUntethered(size);
        Drop<Buffer> drop = memory.drop();
        Buffer buffer = this.manager.recoverMemory(this.pooledAllocatorControl, memory.memory(), drop);
        drop.attach(buffer);
        return buffer;
    }

    @Override
    public Supplier<Buffer> constBufferSupplier(byte[] bytes) {
        if (this.closed) {
            throw Statics.allocatorClosedException();
        }
        Buffer constantBuffer = this.manager.allocateShared(this.pooledAllocatorControl, bytes.length, ArcDrop::wrap, this.allocationType);
        constantBuffer.writeBytes(bytes).makeReadOnly();
        return () -> this.manager.allocateConstChild(constantBuffer);
    }

    UntetheredMemory allocateUntethered(int size) {
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.get();
        PoolArena arena = cache.getArena();
        if (arena != null) {
            return arena.allocate(cache, size);
        }
        return this.allocateUnpooled(size);
    }

    private UntetheredMemory allocateUnpooled(int size) {
        return new UnpooledUntetheredMemory(this, this.manager, this.allocationType, size);
    }

    @Override
    public void close() {
        this.closed = true;
        this.trimCurrentThreadCache();
        this.threadCache.remove();
        for (PoolArena arena : this.arenas) {
            if (arena == null) continue;
            arena.close();
            this.arenas[i] = null;
        }
        this.arenaMetrics.clear();
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static boolean defaultUseCacheForAllThreads() {
        return DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    }

    public static boolean defaultPreferDirect() {
        return PlatformDependent.directBufferPreferred();
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return PlatformDependent.hasUnsafe();
    }

    public boolean isDirectBufferPooled() {
        return this.allocationType == StandardAllocationTypes.OFF_HEAP;
    }

    public int numArenas() {
        return this.arenas.length;
    }

    static PoolArena leastUsedArena(PoolArena[] arenas) {
        if (arenas == null || arenas.length == 0) {
            return null;
        }
        PoolArena minArena = arenas[0];
        for (int i = 1; i < arenas.length; ++i) {
            PoolArena arena = arenas[i];
            if (arena.numThreadCaches.get() >= minArena.numThreadCaches.get()) continue;
            minArena = arena;
        }
        return minArena;
    }

    @Override
    public BufferAllocatorMetric metric() {
        return this.metric;
    }

    List<PoolArenaMetric> arenaMetrics() {
        return this.arenaMetricsView;
    }

    int numThreadLocalCaches() {
        if (this.arenas == null) {
            return 0;
        }
        int total = 0;
        for (PoolArena arena : this.arenas) {
            total += arena.numThreadCaches.get();
        }
        return total;
    }

    int smallCacheSize() {
        return this.smallCacheSize;
    }

    int normalCacheSize() {
        return this.normalCacheSize;
    }

    final int chunkSize() {
        return this.chunkSize;
    }

    final long usedMemory() {
        return PooledBufferAllocator.usedMemory(this.arenas);
    }

    private static long usedMemory(PoolArena[] arenas) {
        if (arenas == null) {
            return -1L;
        }
        long used = 0L;
        for (PoolArena arena : arenas) {
            if ((used += arena.numActiveBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return used;
    }

    final long pinnedMemory() {
        return PooledBufferAllocator.pinnedMemory(this.arenas);
    }

    private static long pinnedMemory(PoolArena[] arenas) {
        if (arenas == null) {
            return -1L;
        }
        long used = 0L;
        for (PoolArena arena : arenas) {
            if ((used += arena.numPinnedBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return used;
    }

    final PoolThreadCache threadCache() {
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.get();
        assert (cache != null);
        return cache;
    }

    public boolean trimCurrentThreadCache() {
        PoolThreadCache cache = (PoolThreadCache)this.threadCache.getIfExists();
        if (cache != null) {
            cache.trim();
            return true;
        }
        return false;
    }

    public String dumpStats() {
        int heapArenasLen = this.arenas == null ? 0 : this.arenas.length;
        StringBuilder buf = new StringBuilder(512).append(heapArenasLen).append(" arena(s):").append(StringUtil.NEWLINE);
        if (heapArenasLen > 0) {
            for (PoolArena a : this.arenas) {
                buf.append(a);
            }
        }
        return buf.toString();
    }

    static {
        int defaultAlignment = SystemPropertyUtil.getInt((String)"io.netty5.allocator.directMemoryCacheAlignment", (int)0);
        int defaultPageSize = SystemPropertyUtil.getInt((String)"io.netty5.allocator.pageSize", (int)8192);
        Throwable pageSizeFallbackCause = null;
        try {
            PooledBufferAllocator.validateAndCalculatePageShifts(defaultPageSize, defaultAlignment);
        }
        catch (Throwable t) {
            pageSizeFallbackCause = t;
            defaultPageSize = 8192;
            defaultAlignment = 0;
        }
        DEFAULT_PAGE_SIZE = defaultPageSize;
        DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = defaultAlignment;
        int defaultMaxOrder = SystemPropertyUtil.getInt((String)"io.netty5.allocator.maxOrder", (int)9);
        Throwable maxOrderFallbackCause = null;
        try {
            PooledBufferAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, defaultMaxOrder);
        }
        catch (Throwable t) {
            maxOrderFallbackCause = t;
            defaultMaxOrder = 11;
        }
        DEFAULT_MAX_ORDER = defaultMaxOrder;
        Runtime runtime = Runtime.getRuntime();
        int defaultMinNumArena = NettyRuntime.availableProcessors() * 2;
        int defaultChunkSize = DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER;
        DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt((String)"io.netty5.allocator.numArenas", (int)((int)Math.min((long)defaultMinNumArena, runtime.maxMemory() / (long)defaultChunkSize / 2L / 3L))));
        DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt((String)"io.netty5.allocator.numDirectArenas", (int)((int)Math.min((long)defaultMinNumArena, PlatformDependent.maxDirectMemory() / (long)defaultChunkSize / 2L / 3L))));
        DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt((String)"io.netty5.allocator.smallCacheSize", (int)256);
        DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt((String)"io.netty5.allocator.normalCacheSize", (int)64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt((String)"io.netty5.allocator.maxCachedBufferCapacity", (int)32768);
        DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt((String)"io.netty5.allocator.cacheTrimInterval", (int)8192);
        DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong((String)"io.netty5.allocator.cacheTrimIntervalMillis", (long)0L);
        DEFAULT_USE_CACHE_FOR_ALL_THREADS = SystemPropertyUtil.getBoolean((String)"io.netty5.allocator.useCacheForAllThreads", (boolean)false);
        DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK = SystemPropertyUtil.getInt((String)"io.netty5.allocator.maxCachedByteBuffersPerChunk", (int)1023);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty5.allocator.numArenas: {}", (Object)DEFAULT_NUM_HEAP_ARENA);
            logger.debug("-Dio.netty5.allocator.numDirectArenas: {}", (Object)DEFAULT_NUM_DIRECT_ARENA);
            if (pageSizeFallbackCause == null) {
                logger.debug("-Dio.netty5.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE);
            } else {
                logger.debug("-Dio.netty5.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE, (Object)pageSizeFallbackCause);
            }
            if (maxOrderFallbackCause == null) {
                logger.debug("-Dio.netty5.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER);
            } else {
                logger.debug("-Dio.netty5.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER, (Object)maxOrderFallbackCause);
            }
            logger.debug("-Dio.netty5.allocator.chunkSize: {}", (Object)(DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER));
            logger.debug("-Dio.netty5.allocator.smallCacheSize: {}", (Object)DEFAULT_SMALL_CACHE_SIZE);
            logger.debug("-Dio.netty5.allocator.normalCacheSize: {}", (Object)DEFAULT_NORMAL_CACHE_SIZE);
            logger.debug("-Dio.netty5.allocator.maxCachedBufferCapacity: {}", (Object)DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            logger.debug("-Dio.netty5.allocator.cacheTrimInterval: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL);
            logger.debug("-Dio.netty5.allocator.cacheTrimIntervalMillis: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL_MILLIS);
            logger.debug("-Dio.netty5.allocator.useCacheForAllThreads: {}", (Object)DEFAULT_USE_CACHE_FOR_ALL_THREADS);
            logger.debug("-Dio.netty5.allocator.maxCachedByteBuffersPerChunk: {}", (Object)DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK);
        }
    }

    final class PoolThreadLocalCache
    extends FastThreadLocal<PoolThreadCache> {
        private final boolean useCacheForAllThreads;

        PoolThreadLocalCache(boolean useCacheForAllThreads) {
            this.useCacheForAllThreads = useCacheForAllThreads;
        }

        protected synchronized PoolThreadCache initialValue() {
            PoolArena arena = PooledBufferAllocator.leastUsedArena(PooledBufferAllocator.this.arenas);
            Thread current = Thread.currentThread();
            EventExecutor executor = ThreadExecutorMap.currentExecutor();
            if (this.useCacheForAllThreads || current instanceof FastThreadLocalThread || executor != null) {
                PoolThreadCache cache = new PoolThreadCache(arena, PooledBufferAllocator.this.smallCacheSize, PooledBufferAllocator.this.normalCacheSize, DEFAULT_MAX_CACHED_BUFFER_CAPACITY, DEFAULT_CACHE_TRIM_INTERVAL);
                if (DEFAULT_CACHE_TRIM_INTERVAL_MILLIS > 0L && executor != null) {
                    executor.scheduleAtFixedRate(PooledBufferAllocator.this.trimTask, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, DEFAULT_CACHE_TRIM_INTERVAL_MILLIS, TimeUnit.MILLISECONDS);
                }
                return cache;
            }
            return new PoolThreadCache(arena, 0, 0, 0, 0);
        }

        protected void onRemoval(PoolThreadCache threadCache) {
            threadCache.free();
        }
    }
}

