/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.buffer.api.pool;

import io.netty5.buffer.api.AllocationType;
import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.Drop;
import io.netty5.buffer.api.MemoryManager;
import io.netty5.buffer.api.internal.DropCaptor;
import io.netty5.buffer.api.internal.Statics;
import io.netty5.buffer.api.pool.PooledBufferAllocator;
import io.netty5.buffer.api.pool.UntetheredMemory;

class UnpooledUntetheredMemory
implements UntetheredMemory {
    private final MemoryManager manager;
    private final Buffer buffer;
    private final DropCaptor<Buffer> dropCaptor;

    UnpooledUntetheredMemory(PooledBufferAllocator allocator, MemoryManager manager, AllocationType allocationType, int size) {
        this.manager = manager;
        this.dropCaptor = new DropCaptor();
        this.buffer = manager.allocateShared(allocator.getPooledAllocatorControl(), size, this.dropCaptor, allocationType);
    }

    @Override
    public <Memory> Memory memory() {
        return (Memory)this.manager.unwrapRecoverableMemory(this.buffer);
    }

    @Override
    public <BufferType extends Buffer> Drop<BufferType> drop() {
        return Statics.standardDrop(this.manager).apply(this.dropCaptor.getDrop());
    }
}

