/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.handler.codec.dns.DnsMessageUtil;
import io.netty5.handler.codec.dns.DnsRecord;
import io.netty5.handler.codec.dns.DnsRecordType;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import java.net.IDN;
import java.util.Objects;

@UnstableApi
public abstract class AbstractDnsRecord
implements DnsRecord {
    private final String name;
    private final DnsRecordType type;
    private final short dnsClass;
    private final long timeToLive;
    private int hashCode;

    protected AbstractDnsRecord(String name, DnsRecordType type, long timeToLive) {
        this(name, type, 1, timeToLive);
    }

    protected AbstractDnsRecord(String name, DnsRecordType type, int dnsClass, long timeToLive) {
        ObjectUtil.checkPositiveOrZero((long)timeToLive, (String)"timeToLive");
        this.name = AbstractDnsRecord.appendTrailingDot(AbstractDnsRecord.IDNtoASCII(name));
        this.type = Objects.requireNonNull(type, "type");
        this.dnsClass = (short)dnsClass;
        this.timeToLive = timeToLive;
    }

    private static String IDNtoASCII(String name) {
        Objects.requireNonNull(name, "name");
        if (PlatformDependent.isAndroid() && ".".equals(name)) {
            return name;
        }
        return IDN.toASCII(name);
    }

    private static String appendTrailingDot(String name) {
        if (name.length() > 0 && name.charAt(name.length() - 1) != '.') {
            return name + ".";
        }
        return name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DnsRecordType type() {
        return this.type;
    }

    @Override
    public int dnsClass() {
        return this.dnsClass & 0xFFFF;
    }

    @Override
    public long timeToLive() {
        return this.timeToLive;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DnsRecord)) {
            return false;
        }
        DnsRecord that = (DnsRecord)obj;
        int hashCode = this.hashCode;
        if (hashCode != 0 && hashCode != that.hashCode()) {
            return false;
        }
        return this.type().intValue() == that.type().intValue() && this.dnsClass() == that.dnsClass() && this.name().equals(that.name());
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode != 0) {
            return hashCode;
        }
        this.hashCode = this.name.hashCode() * 31 + this.type().intValue() * 31 + this.dnsClass();
        return this.hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(StringUtil.simpleClassName((Object)this)).append('(').append(this.name()).append(' ').append(this.timeToLive()).append(' ');
        DnsMessageUtil.appendRecordClass(buf, this.dnsClass()).append(' ').append(this.type().name()).append(')');
        return buf.toString();
    }
}

