/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.handler.codec.MessageToMessageDecoder;
import io.netty5.handler.codec.dns.DatagramDnsQuery;
import io.netty5.handler.codec.dns.DnsMessageUtil;
import io.netty5.handler.codec.dns.DnsQuery;
import io.netty5.handler.codec.dns.DnsRecordDecoder;
import io.netty5.util.internal.UnstableApi;
import java.net.InetSocketAddress;
import java.util.Objects;

@ChannelHandler.Sharable
@UnstableApi
public class DatagramDnsQueryDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsRecordDecoder recordDecoder;

    public DatagramDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsQueryDecoder(DnsRecordDecoder recordDecoder) {
        this.recordDecoder = Objects.requireNonNull(recordDecoder, "recordDecoder");
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        DnsQuery query = DnsMessageUtil.decodeDnsQuery(this.recordDecoder, ctx.bufferAllocator(), (Buffer)packet.content(), (id, dnsOpCode) -> new DatagramDnsQuery((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), id, dnsOpCode));
        ctx.fireChannelRead((Object)query);
    }
}

