/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.handler.codec.CorruptedFrameException;
import io.netty5.handler.codec.MessageToMessageDecoder;
import io.netty5.handler.codec.dns.DatagramDnsResponse;
import io.netty5.handler.codec.dns.DnsOpCode;
import io.netty5.handler.codec.dns.DnsRecordDecoder;
import io.netty5.handler.codec.dns.DnsResponse;
import io.netty5.handler.codec.dns.DnsResponseCode;
import io.netty5.handler.codec.dns.DnsResponseDecoder;
import io.netty5.util.internal.UnstableApi;
import java.net.InetSocketAddress;

@ChannelHandler.Sharable
@UnstableApi
public class DatagramDnsResponseDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private final DnsResponseDecoder<InetSocketAddress> responseDecoder;

    public DatagramDnsResponseDecoder() {
        this(DnsRecordDecoder.DEFAULT);
    }

    public DatagramDnsResponseDecoder(DnsRecordDecoder recordDecoder) {
        this.responseDecoder = new DnsResponseDecoder<InetSocketAddress>(recordDecoder){

            @Override
            protected DnsResponse newResponse(InetSocketAddress sender, InetSocketAddress recipient, int id, DnsOpCode opCode, DnsResponseCode responseCode) {
                return new DatagramDnsResponse(sender, recipient, id, opCode, responseCode);
            }
        };
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        DnsResponse response;
        try {
            response = this.decodeResponse(ctx, packet);
        }
        catch (IndexOutOfBoundsException e) {
            throw new CorruptedFrameException("Unable to decode response", (Throwable)e);
        }
        ctx.fireChannelRead((Object)response);
    }

    protected DnsResponse decodeResponse(ChannelHandlerContext ctx, DatagramPacket packet) throws Exception {
        return this.responseDecoder.decode((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), ctx.bufferAllocator(), (Buffer)packet.content());
    }
}

