/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.Send;
import io.netty5.handler.codec.dns.AbstractDnsRecord;
import io.netty5.handler.codec.dns.DnsMessageUtil;
import io.netty5.handler.codec.dns.DnsRawRecord;
import io.netty5.handler.codec.dns.DnsRecordType;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public class DefaultDnsRawRecord
extends AbstractDnsRecord
implements DnsRawRecord {
    private final Buffer content;

    public DefaultDnsRawRecord(String name, DnsRecordType type, long timeToLive, Buffer content) {
        this(name, type, 1, timeToLive, content);
    }

    public DefaultDnsRawRecord(String name, DnsRecordType type, int dnsClass, long timeToLive, Buffer content) {
        super(name, type, dnsClass, timeToLive);
        this.content = Objects.requireNonNull(content, "content");
    }

    public DefaultDnsRawRecord(String name, DnsRecordType type, int dnsClass, long timeToLive, Send<Buffer> content) {
        super(name, type, dnsClass, timeToLive);
        this.content = (Buffer)Objects.requireNonNull(content, "content").receive();
    }

    @Override
    public Buffer content() {
        return this.content;
    }

    public DnsRawRecord replace(Buffer content) {
        return new DefaultDnsRawRecord(this.name(), this.type(), this.dnsClass(), this.timeToLive(), content);
    }

    public Send<DnsRawRecord> send() {
        return this.content.send().map(DnsRawRecord.class, this::replace);
    }

    public void close() {
        this.content.close();
    }

    public boolean isAccessible() {
        return this.content.isAccessible();
    }

    @Override
    public DnsRawRecord touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(64).append(StringUtil.simpleClassName((Object)this)).append('(');
        DnsRecordType type = this.type();
        if (type != DnsRecordType.OPT) {
            buf.append(this.name().isEmpty() ? "<root>" : this.name()).append(' ').append(this.timeToLive()).append(' ');
            DnsMessageUtil.appendRecordClass(buf, this.dnsClass()).append(' ').append(type.name());
        } else {
            buf.append("OPT flags:").append(this.timeToLive()).append(" udp:").append(this.dnsClass());
        }
        buf.append(' ').append(this.content().readableBytes()).append("B)");
        return buf.toString();
    }
}

