/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.dns.DefaultDnsPtrRecord;
import io.netty5.handler.codec.dns.DefaultDnsQuestion;
import io.netty5.handler.codec.dns.DefaultDnsRawRecord;
import io.netty5.handler.codec.dns.DnsCodecUtil;
import io.netty5.handler.codec.dns.DnsQuestion;
import io.netty5.handler.codec.dns.DnsRecord;
import io.netty5.handler.codec.dns.DnsRecordDecoder;
import io.netty5.handler.codec.dns.DnsRecordType;
import io.netty5.util.internal.UnstableApi;

@UnstableApi
public class DefaultDnsRecordDecoder
implements DnsRecordDecoder {
    static final String ROOT = ".";

    protected DefaultDnsRecordDecoder() {
    }

    @Override
    public final DnsQuestion decodeQuestion(Buffer in) throws Exception {
        String name = DefaultDnsRecordDecoder.decodeName(in);
        DnsRecordType type = DnsRecordType.valueOf(in.readUnsignedShort());
        int qClass = in.readUnsignedShort();
        return new DefaultDnsQuestion(name, type, qClass);
    }

    @Override
    public final <T extends DnsRecord> T decodeRecord(BufferAllocator allocator, Buffer in) throws Exception {
        int startOffset = in.readerOffset();
        String name = DefaultDnsRecordDecoder.decodeName(in);
        int endOffset = in.writerOffset();
        if (endOffset - in.readerOffset() < 10) {
            in.readerOffset(startOffset);
            return null;
        }
        DnsRecordType type = DnsRecordType.valueOf(in.readUnsignedShort());
        int aClass = in.readUnsignedShort();
        long ttl = in.readUnsignedInt();
        int length = in.readUnsignedShort();
        int offset = in.readerOffset();
        if (endOffset - offset < length) {
            in.readerOffset(startOffset);
            return null;
        }
        DnsRecord record = this.decodeRecord(name, type, aClass, ttl, allocator, in, offset, length);
        in.readerOffset(offset + length);
        return (T)record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DnsRecord decodeRecord(String name, DnsRecordType type, int dnsClass, long timeToLive, BufferAllocator allocator, Buffer in, int offset, int length) throws Exception {
        int roff = in.readerOffset();
        int woff = in.writerOffset();
        in.resetOffsets().writerOffset(offset + length).readerOffset(offset);
        try {
            if (type == DnsRecordType.PTR) {
                DefaultDnsPtrRecord defaultDnsPtrRecord = new DefaultDnsPtrRecord(name, dnsClass, timeToLive, this.decodeName0(in));
                return defaultDnsPtrRecord;
            }
            if (type == DnsRecordType.CNAME || type == DnsRecordType.NS) {
                DefaultDnsRawRecord defaultDnsRawRecord = new DefaultDnsRawRecord(name, type, dnsClass, timeToLive, DnsCodecUtil.decompressDomainName(allocator, in));
                return defaultDnsRawRecord;
            }
            DefaultDnsRawRecord defaultDnsRawRecord = new DefaultDnsRawRecord(name, type, dnsClass, timeToLive, in.copy());
            return defaultDnsRawRecord;
        }
        finally {
            in.resetOffsets().writerOffset(woff).readerOffset(roff);
        }
    }

    protected String decodeName0(Buffer in) {
        return DefaultDnsRecordDecoder.decodeName(in);
    }

    public static String decodeName(Buffer in) {
        return DnsCodecUtil.decodeDomainName(in);
    }
}

