/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.socket.InternetProtocolFamily;
import io.netty5.handler.codec.UnsupportedMessageTypeException;
import io.netty5.handler.codec.dns.DnsCodecUtil;
import io.netty5.handler.codec.dns.DnsOptEcsRecord;
import io.netty5.handler.codec.dns.DnsOptPseudoRecord;
import io.netty5.handler.codec.dns.DnsPtrRecord;
import io.netty5.handler.codec.dns.DnsQuestion;
import io.netty5.handler.codec.dns.DnsRawRecord;
import io.netty5.handler.codec.dns.DnsRecord;
import io.netty5.handler.codec.dns.DnsRecordEncoder;
import io.netty5.util.internal.StringUtil;
import io.netty5.util.internal.UnstableApi;

@UnstableApi
public class DefaultDnsRecordEncoder
implements DnsRecordEncoder {
    private static final int PREFIX_MASK = 7;

    protected DefaultDnsRecordEncoder() {
    }

    @Override
    public final void encodeQuestion(DnsQuestion question, Buffer out) throws Exception {
        this.encodeName(question.name(), out);
        out.ensureWritable(4);
        out.writeShort((short)question.type().intValue());
        out.writeShort((short)question.dnsClass());
    }

    @Override
    public void encodeRecord(DnsRecord record, Buffer out) throws Exception {
        if (record instanceof DnsQuestion) {
            this.encodeQuestion((DnsQuestion)record, out);
        } else if (record instanceof DnsPtrRecord) {
            this.encodePtrRecord((DnsPtrRecord)record, out);
        } else if (record instanceof DnsOptEcsRecord) {
            this.encodeOptEcsRecord((DnsOptEcsRecord)record, out);
        } else if (record instanceof DnsOptPseudoRecord) {
            this.encodeOptPseudoRecord((DnsOptPseudoRecord)record, out);
        } else if (record instanceof DnsRawRecord) {
            this.encodeRawRecord((DnsRawRecord)record, out);
        } else {
            throw new UnsupportedMessageTypeException(StringUtil.simpleClassName((Object)record));
        }
    }

    private void encodeRecord0(DnsRecord record, Buffer out) throws Exception {
        this.encodeName(record.name(), out);
        out.ensureWritable(8);
        out.writeShort((short)record.type().intValue());
        out.writeShort((short)record.dnsClass());
        out.writeInt((int)record.timeToLive());
    }

    private void encodePtrRecord(DnsPtrRecord record, Buffer out) throws Exception {
        this.encodeRecord0(record, out);
        this.encodeName(record.hostname(), out);
    }

    private void encodeOptPseudoRecord(DnsOptPseudoRecord record, Buffer out) throws Exception {
        this.encodeRecord0(record, out);
        out.ensureWritable(2);
        out.writeShort((short)0);
    }

    private void encodeOptEcsRecord(DnsOptEcsRecord record, Buffer out) throws Exception {
        this.encodeRecord0(record, out);
        int sourcePrefixLength = record.sourcePrefixLength();
        int scopePrefixLength = record.scopePrefixLength();
        int lowOrderBitsToPreserve = sourcePrefixLength & 7;
        byte[] bytes = record.address();
        int addressBits = bytes.length << 3;
        if (addressBits < sourcePrefixLength || sourcePrefixLength < 0) {
            throw new IllegalArgumentException(sourcePrefixLength + ": " + sourcePrefixLength + " (expected: 0 >= " + addressBits + ")");
        }
        short addressNumber = (short)(bytes.length == 4 ? InternetProtocolFamily.IPv4.addressNumber() : InternetProtocolFamily.IPv6.addressNumber());
        int payloadLength = DefaultDnsRecordEncoder.calculateEcsAddressLength(sourcePrefixLength, lowOrderBitsToPreserve);
        int fullPayloadLength = 8 + payloadLength;
        out.ensureWritable(fullPayloadLength);
        out.writeShort((short)fullPayloadLength);
        out.writeShort((short)8);
        out.writeShort((short)(fullPayloadLength - 4));
        out.writeShort(addressNumber);
        out.writeByte((byte)sourcePrefixLength);
        out.writeByte((byte)scopePrefixLength);
        if (lowOrderBitsToPreserve > 0) {
            int bytesLength = payloadLength - 1;
            out.writeBytes(bytes, 0, bytesLength);
            out.writeByte(DefaultDnsRecordEncoder.padWithZeros(bytes[bytesLength], lowOrderBitsToPreserve));
        } else {
            out.writeBytes(bytes, 0, payloadLength);
        }
    }

    static int calculateEcsAddressLength(int sourcePrefixLength, int lowOrderBitsToPreserve) {
        return (sourcePrefixLength >>> 3) + (lowOrderBitsToPreserve != 0 ? 1 : 0);
    }

    private void encodeRawRecord(DnsRawRecord record, Buffer out) throws Exception {
        this.encodeRecord0(record, out);
        Buffer content = record.content();
        int contentLen = content.readableBytes();
        out.ensureWritable(2 + contentLen);
        out.writeShort((short)contentLen);
        content.copyInto(content.readerOffset(), out, out.writerOffset(), contentLen);
        out.skipWritable(contentLen);
    }

    protected void encodeName(String name, Buffer buf) throws Exception {
        DnsCodecUtil.encodeDomainName(name, buf);
    }

    private static byte padWithZeros(byte b, int lowOrderBitsToPreserve) {
        switch (lowOrderBitsToPreserve) {
            case 0: {
                return 0;
            }
            case 1: {
                return (byte)(0x80 & b);
            }
            case 2: {
                return (byte)(0xC0 & b);
            }
            case 3: {
                return (byte)(0xE0 & b);
            }
            case 4: {
                return (byte)(0xF0 & b);
            }
            case 5: {
                return (byte)(0xF8 & b);
            }
            case 6: {
                return (byte)(0xFC & b);
            }
            case 7: {
                return (byte)(0xFE & b);
            }
            case 8: {
                return b;
            }
        }
        throw new IllegalArgumentException("lowOrderBitsToPreserve: " + lowOrderBitsToPreserve);
    }
}

