/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.CorruptedFrameException;
import java.nio.charset.StandardCharsets;

final class DnsCodecUtil {
    private DnsCodecUtil() {
    }

    static void encodeDomainName(String name, Buffer buf) {
        String label;
        int labelLen;
        String[] labels;
        if (".".equals(name)) {
            buf.ensureWritable(1);
            buf.writeByte((byte)0);
            return;
        }
        buf.ensureWritable(name.length() + 1);
        String[] stringArray = labels = name.split("\\.");
        int n = stringArray.length;
        for (int i = 0; i < n && (labelLen = (label = stringArray[i]).length()) != 0; ++i) {
            buf.writeByte((byte)labelLen);
            buf.writeBytes(label.getBytes(StandardCharsets.US_ASCII));
        }
        buf.writeByte((byte)0);
    }

    static String decodeDomainName(Buffer in) {
        int position = -1;
        int checked = 0;
        int end = in.writerOffset();
        int readable = in.readableBytes();
        if (readable == 0) {
            return ".";
        }
        StringBuilder name = new StringBuilder(readable << 1);
        while (in.readableBytes() > 0) {
            boolean pointer;
            int len = in.readUnsignedByte();
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                if (position == -1) {
                    position = in.readerOffset() + 1;
                }
                if (in.readableBytes() == 0) {
                    throw new CorruptedFrameException("truncated pointer in a name");
                }
                int next = (len & 0x3F) << 8 | in.readUnsignedByte();
                if (next >= end) {
                    throw new CorruptedFrameException("name has an out-of-range pointer");
                }
                in.readerOffset(next);
                if ((checked += 2) < end) continue;
                throw new CorruptedFrameException("name contains a loop.");
            }
            if (len == 0) break;
            if (in.readableBytes() < len) {
                throw new CorruptedFrameException("truncated label in a name");
            }
            name.append(in.readCharSequence(len, StandardCharsets.UTF_8)).append('.');
        }
        if (position != -1) {
            in.readerOffset(position);
        }
        if (name.length() == 0) {
            return ".";
        }
        if (name.charAt(name.length() - 1) != '.') {
            name.append('.');
        }
        return name.toString();
    }

    static Buffer decompressDomainName(BufferAllocator allocator, Buffer compression) {
        String domainName = DnsCodecUtil.decodeDomainName(compression);
        Buffer result = allocator.allocate(domainName.length() << 1);
        DnsCodecUtil.encodeDomainName(domainName, result);
        return result;
    }
}

