/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.handler.codec.dns.DnsQuery;
import io.netty5.handler.codec.dns.DnsQuestion;
import io.netty5.handler.codec.dns.DnsRecord;
import io.netty5.handler.codec.dns.DnsRecordEncoder;
import io.netty5.handler.codec.dns.DnsSection;
import java.util.Objects;

final class DnsQueryEncoder {
    private final DnsRecordEncoder recordEncoder;

    DnsQueryEncoder(DnsRecordEncoder recordEncoder) {
        this.recordEncoder = Objects.requireNonNull(recordEncoder, "recordEncoder");
    }

    void encode(DnsQuery query, Buffer out) throws Exception {
        DnsQueryEncoder.encodeHeader(query, out);
        this.encodeQuestions(query, out);
        this.encodeRecords(query, DnsSection.ADDITIONAL, out);
    }

    private static void encodeHeader(DnsQuery query, Buffer buf) {
        buf.ensureWritable(12);
        buf.writeShort((short)query.id());
        short flags = 0;
        flags = (short)(flags | (query.opCode().byteValue() & 0xFF) << 14);
        if (query.isRecursionDesired()) {
            flags = (short)(flags | 0x100);
        }
        buf.writeShort(flags);
        buf.writeShort((short)query.count(DnsSection.QUESTION));
        buf.writeShort((short)0);
        buf.writeShort((short)0);
        buf.writeShort((short)query.count(DnsSection.ADDITIONAL));
    }

    private void encodeQuestions(DnsQuery query, Buffer buf) throws Exception {
        int count = query.count(DnsSection.QUESTION);
        for (int i = 0; i < count; ++i) {
            this.recordEncoder.encodeQuestion((DnsQuestion)query.recordAt(DnsSection.QUESTION, i), buf);
        }
    }

    private void encodeRecords(DnsQuery query, DnsSection section, Buffer buf) throws Exception {
        int count = query.count(section);
        for (int i = 0; i < count; ++i) {
            this.recordEncoder.encodeRecord((DnsRecord)query.recordAt(section, i), buf);
        }
    }
}

