/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.LengthFieldBasedFrameDecoderForBuffer;
import io.netty5.handler.codec.dns.DefaultDnsQuery;
import io.netty5.handler.codec.dns.DnsMessageUtil;
import io.netty5.handler.codec.dns.DnsRecordDecoder;
import io.netty5.util.internal.UnstableApi;
import java.util.Objects;

@UnstableApi
public final class TcpDnsQueryDecoder
extends LengthFieldBasedFrameDecoderForBuffer {
    private final DnsRecordDecoder decoder;

    public TcpDnsQueryDecoder() {
        this(DnsRecordDecoder.DEFAULT, 65535);
    }

    public TcpDnsQueryDecoder(DnsRecordDecoder decoder, int maxFrameLength) {
        super(maxFrameLength, 0, 2, 0, 2);
        this.decoder = Objects.requireNonNull(decoder, "decoder");
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer in) throws Exception {
        Buffer frame = (Buffer)super.decode0(ctx, in);
        if (frame == null) {
            return null;
        }
        return DnsMessageUtil.decodeDnsQuery(this.decoder, ctx.bufferAllocator(), frame.split(), DefaultDnsQuery::new);
    }
}

