/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToByteEncoderForBuffer;
import io.netty5.handler.codec.dns.DnsQuery;
import io.netty5.handler.codec.dns.DnsQueryEncoder;
import io.netty5.handler.codec.dns.DnsRecordEncoder;
import io.netty5.util.internal.UnstableApi;

@ChannelHandler.Sharable
@UnstableApi
public final class TcpDnsQueryEncoder
extends MessageToByteEncoderForBuffer<DnsQuery> {
    private final DnsQueryEncoder encoder;

    public TcpDnsQueryEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsQueryEncoder(DnsRecordEncoder recordEncoder) {
        this.encoder = new DnsQueryEncoder(recordEncoder);
    }

    protected void encode(ChannelHandlerContext ctx, DnsQuery msg, Buffer out) throws Exception {
        int initialOffset = out.writerOffset();
        out.skipWritable(2);
        this.encoder.encode(msg, out);
        out.setShort(initialOffset, (short)(out.writerOffset() - initialOffset - 2));
    }

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, DnsQuery msg) {
        return ctx.bufferAllocator().allocate(1024);
    }
}

