/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.LengthFieldBasedFrameDecoderForBuffer;
import io.netty5.handler.codec.dns.DefaultDnsResponse;
import io.netty5.handler.codec.dns.DnsOpCode;
import io.netty5.handler.codec.dns.DnsRecordDecoder;
import io.netty5.handler.codec.dns.DnsResponse;
import io.netty5.handler.codec.dns.DnsResponseCode;
import io.netty5.handler.codec.dns.DnsResponseDecoder;
import io.netty5.util.internal.UnstableApi;
import java.net.SocketAddress;

@UnstableApi
public final class TcpDnsResponseDecoder
extends LengthFieldBasedFrameDecoderForBuffer {
    private final DnsResponseDecoder<SocketAddress> responseDecoder;

    public TcpDnsResponseDecoder() {
        this(DnsRecordDecoder.DEFAULT, 65536);
    }

    public TcpDnsResponseDecoder(DnsRecordDecoder recordDecoder, int maxFrameLength) {
        super(maxFrameLength, 0, 2, 0, 2);
        this.responseDecoder = new DnsResponseDecoder<SocketAddress>(recordDecoder){

            @Override
            protected DnsResponse newResponse(SocketAddress sender, SocketAddress recipient, int id, DnsOpCode opCode, DnsResponseCode responseCode) {
                return new DefaultDnsResponse(id, opCode, responseCode);
            }
        };
    }

    protected Object decode0(ChannelHandlerContext ctx, Buffer in) throws Exception {
        try (Buffer frame = (Buffer)super.decode0(ctx, in);){
            if (frame == null) {
                Object var4_4 = null;
                return var4_4;
            }
            SocketAddress sender = ctx.channel().remoteAddress();
            SocketAddress recipient = ctx.channel().localAddress();
            DnsResponse dnsResponse = this.responseDecoder.decode(sender, recipient, ctx.bufferAllocator(), frame.split());
            return dnsResponse;
        }
    }
}

