/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.dns;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageEncoder;
import io.netty5.handler.codec.dns.DnsMessageUtil;
import io.netty5.handler.codec.dns.DnsRecordEncoder;
import io.netty5.handler.codec.dns.DnsResponse;
import io.netty5.util.internal.UnstableApi;
import java.util.List;
import java.util.Objects;

@ChannelHandler.Sharable
@UnstableApi
public final class TcpDnsResponseEncoder
extends MessageToMessageEncoder<DnsResponse> {
    private final DnsRecordEncoder encoder;

    public TcpDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsResponseEncoder(DnsRecordEncoder encoder) {
        this.encoder = Objects.requireNonNull(encoder, "encoder");
    }

    protected void encode(ChannelHandlerContext ctx, DnsResponse response, List<Object> out) throws Exception {
        Buffer buf = ctx.bufferAllocator().allocate(1024);
        buf.skipWritable(2);
        DnsMessageUtil.encodeDnsResponse(this.encoder, response, buf);
        buf.setShort(0, (short)(buf.readableBytes() - 2));
        out.add(buf);
    }
}

