/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferClosedException;
import io.netty5.handler.codec.http.CombinedHttpHeaders;
import io.netty5.handler.codec.http.DefaultHttpHeaders;
import io.netty5.handler.codec.http.DefaultHttpResponse;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpHeaders;
import io.netty5.handler.codec.http.HttpMessageUtil;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.util.Send;
import java.util.Objects;

public class DefaultFullHttpResponse
extends DefaultHttpResponse
implements FullHttpResponse {
    private final Buffer payload;
    private final HttpHeaders trailingHeaders;
    private int hash;

    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, Buffer payload) {
        this(version, status, payload, true);
    }

    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, Buffer payload, boolean validateHeaders) {
        this(version, status, payload, validateHeaders, false);
    }

    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, Buffer payload, boolean validateHeaders, boolean singleFieldHeaders) {
        super(version, status, validateHeaders, singleFieldHeaders);
        this.payload = Objects.requireNonNull(payload, "payload");
        this.trailingHeaders = singleFieldHeaders ? new CombinedHttpHeaders(validateHeaders) : new DefaultHttpHeaders(validateHeaders);
    }

    public DefaultFullHttpResponse(HttpVersion version, HttpResponseStatus status, Buffer payload, HttpHeaders headers, HttpHeaders trailingHeaders) {
        super(version, status, headers);
        this.payload = Objects.requireNonNull(payload, "payload");
        this.trailingHeaders = Objects.requireNonNull(trailingHeaders, "trailingHeaders");
    }

    public void close() {
        this.payload.close();
    }

    public boolean isAccessible() {
        return this.payload.isAccessible();
    }

    public FullHttpResponse touch(Object hint) {
        this.payload.touch(hint);
        return this;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }

    public Send<FullHttpResponse> send() {
        return this.payload.send().map(FullHttpResponse.class, payload -> new DefaultFullHttpResponse(this.protocolVersion(), this.status(), (Buffer)payload, this.headers(), this.trailingHeaders));
    }

    @Override
    public DefaultFullHttpResponse copy() {
        return new DefaultFullHttpResponse(this.protocolVersion(), this.status(), this.payload.copy(), this.headers().copy(), this.trailingHeaders.copy());
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    @Override
    public FullHttpResponse setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public FullHttpResponse setStatus(HttpResponseStatus status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public int hashCode() {
        int hash = this.hash;
        if (hash == 0) {
            Buffer payload = this.payload();
            if (payload.isAccessible()) {
                try {
                    hash = 31 + payload.hashCode();
                }
                catch (BufferClosedException ignored) {
                    hash = 31;
                }
            } else {
                hash = 31;
            }
            hash = 31 * hash + this.trailingHeaders().hashCode();
            this.hash = hash = 31 * hash + super.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultFullHttpResponse)) {
            return false;
        }
        DefaultFullHttpResponse other = (DefaultFullHttpResponse)o;
        return super.equals(other) && this.payload().equals(other.payload()) && this.trailingHeaders().equals(other.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
    }
}

