/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.Buffer;
import io.netty5.handler.codec.http.DefaultHttpObject;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.util.Send;
import io.netty5.util.internal.StringUtil;
import java.util.Objects;

public class DefaultHttpContent
extends DefaultHttpObject
implements HttpContent<DefaultHttpContent> {
    private final Buffer payload;

    public DefaultHttpContent(Buffer payload) {
        this.payload = Objects.requireNonNull(payload, "payload");
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(data: " + this.payload() + ", decoderResult: " + this.decoderResult() + ")";
    }

    public Send<DefaultHttpContent> send() {
        return this.payload.send().map(DefaultHttpContent.class, DefaultHttpContent::new);
    }

    @Override
    public DefaultHttpContent copy() {
        return new DefaultHttpContent(this.payload.copy());
    }

    public void close() {
        this.payload.close();
    }

    public boolean isAccessible() {
        return this.payload.isAccessible();
    }

    public DefaultHttpContent touch(Object hint) {
        this.payload.touch(hint);
        return this;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }
}

