/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.Buffer;
import io.netty5.handler.codec.DefaultHeaders;
import io.netty5.handler.codec.http.DefaultHttpHeaders;
import io.netty5.handler.codec.http.DefaultHttpObject;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaders;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.util.Send;
import io.netty5.util.internal.StringUtil;
import java.util.Map;
import java.util.Objects;

public class DefaultLastHttpContent
extends DefaultHttpObject
implements LastHttpContent<DefaultLastHttpContent> {
    private final HttpHeaders trailingHeaders;
    private final Buffer payload;

    public DefaultLastHttpContent(Buffer payload) {
        this(payload, true);
    }

    public DefaultLastHttpContent(Buffer payload, boolean validateHeaders) {
        this(payload, new TrailingHttpHeaders(validateHeaders));
    }

    public DefaultLastHttpContent(Buffer payload, HttpHeaders trailingHeaders) {
        this.payload = Objects.requireNonNull(payload, "payload");
        this.trailingHeaders = Objects.requireNonNull(trailingHeaders, "trailingHeaders");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        for (Map.Entry<String, String> e : this.trailingHeaders()) {
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }

    public Send<DefaultLastHttpContent> send() {
        return this.payload.send().map(DefaultLastHttpContent.class, payload -> new DefaultLastHttpContent((Buffer)payload, this.trailingHeaders));
    }

    @Override
    public DefaultLastHttpContent copy() {
        return new DefaultLastHttpContent(this.payload.copy(), this.trailingHeaders.copy());
    }

    public void close() {
        this.payload.close();
    }

    public boolean isAccessible() {
        return this.payload.isAccessible();
    }

    public DefaultLastHttpContent touch(Object hint) {
        this.payload.touch(hint);
        return this;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }

    private static final class TrailingHttpHeaders
    extends DefaultHttpHeaders {
        private static final DefaultHeaders.NameValidator<CharSequence> TrailerNameValidator = name -> {
            DefaultHttpHeaders.HttpNameValidator.validateName(name);
            if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(name) || HttpHeaderNames.TRANSFER_ENCODING.contentEqualsIgnoreCase(name) || HttpHeaderNames.TRAILER.contentEqualsIgnoreCase(name)) {
                throw new IllegalArgumentException("prohibited trailing header: " + name);
            }
        };

        TrailingHttpHeaders(boolean validate) {
            super(validate, (DefaultHeaders.NameValidator<CharSequence>)(validate ? TrailerNameValidator : DefaultHeaders.NameValidator.NOT_NULL));
        }
    }
}

