/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.http.DefaultHttpContent;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.stream.ChunkedInput;
import io.netty5.util.Resource;

public class HttpChunkedInput
implements ChunkedInput<HttpContent<?>> {
    private final ChunkedInput<Buffer> input;
    private final LastHttpContent<?> lastHttpContent;
    private boolean sentLastChunk;

    public HttpChunkedInput(ChunkedInput<Buffer> input, LastHttpContent<?> lastHttpContent) {
        this.input = input;
        this.lastHttpContent = lastHttpContent;
    }

    public boolean isEndOfInput() throws Exception {
        if (this.input.isEndOfInput()) {
            return this.sentLastChunk;
        }
        return false;
    }

    public void close() throws Exception {
        try (ChunkedInput<Buffer> chunkedInput = this.input;){
            if (!this.sentLastChunk && Resource.isAccessible(this.lastHttpContent, (boolean)false)) {
                Resource.dispose(this.lastHttpContent);
            }
        }
    }

    public HttpContent<?> readChunk(BufferAllocator allocator) throws Exception {
        if (this.input.isEndOfInput()) {
            if (this.sentLastChunk) {
                return null;
            }
            this.sentLastChunk = true;
            return this.lastHttpContent;
        }
        Buffer buf = (Buffer)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        return new DefaultHttpContent(buf);
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }
}

