/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.handler.codec.compression.Brotli;
import io.netty5.handler.codec.compression.BrotliDecompressor;
import io.netty5.handler.codec.compression.Decompressor;
import io.netty5.handler.codec.compression.ZlibDecompressor;
import io.netty5.handler.codec.compression.ZlibWrapper;
import io.netty5.handler.codec.http.HttpContentDecoder;
import io.netty5.handler.codec.http.HttpHeaderValues;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    public HttpContentDecompressor(boolean strict) {
        this.strict = strict;
    }

    @Override
    protected Decompressor newContentDecoder(String contentEncoding) throws Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            return (Decompressor)ZlibDecompressor.newFactory((ZlibWrapper)ZlibWrapper.GZIP).get();
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            ZlibDecompressor.newFactory((ZlibWrapper)wrapper).get();
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            return (Decompressor)BrotliDecompressor.newFactory().get();
        }
        return null;
    }
}

