/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.MessageToMessageCodec;
import io.netty5.handler.codec.compression.Compressor;
import io.netty5.handler.codec.http.DefaultHttpContent;
import io.netty5.handler.codec.http.DefaultHttpResponse;
import io.netty5.handler.codec.http.DefaultLastHttpContent;
import io.netty5.handler.codec.http.EmptyLastHttpContent;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpContentDecoder;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpHeaders;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.util.Resource;
import io.netty5.util.internal.StringUtil;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.Queue;

public abstract class HttpContentEncoder
extends MessageToMessageCodec<HttpRequest, HttpObject> {
    private static final CharSequence ZERO_LENGTH_HEAD = "HEAD";
    private static final CharSequence ZERO_LENGTH_CONNECT = "CONNECT";
    private static final int CONTINUE_CODE = HttpResponseStatus.CONTINUE.code();
    private final Queue<CharSequence> acceptEncodingQueue = new ArrayDeque<CharSequence>();
    private Compressor compressor;
    private State state = State.AWAIT_HEADERS;

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof HttpContent || msg instanceof HttpResponse;
    }

    protected void decode(ChannelHandlerContext ctx, HttpRequest msg) throws Exception {
        throw new UnsupportedOperationException("HttpContentEncoder use decodeAndClose().");
    }

    protected void decodeAndClose(ChannelHandlerContext ctx, HttpRequest msg) throws Exception {
        CharSequence acceptEncoding;
        List<String> acceptEncodingHeaders = msg.headers().getAll((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        switch (acceptEncodingHeaders.size()) {
            case 0: {
                acceptEncoding = HttpContentDecoder.IDENTITY;
                break;
            }
            case 1: {
                acceptEncoding = acceptEncodingHeaders.get(0);
                break;
            }
            default: {
                acceptEncoding = StringUtil.join((CharSequence)",", acceptEncodingHeaders);
            }
        }
        HttpMethod method = msg.method();
        if (HttpMethod.HEAD.equals(method)) {
            acceptEncoding = ZERO_LENGTH_HEAD;
        } else if (HttpMethod.CONNECT.equals(method)) {
            acceptEncoding = ZERO_LENGTH_CONNECT;
        }
        this.acceptEncodingQueue.add(acceptEncoding);
        ctx.fireChannelRead((Object)msg);
    }

    protected void encodeAndClose(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        boolean isFull = msg instanceof HttpResponse && msg instanceof LastHttpContent;
        boolean dispose = true;
        switch (this.state) {
            case AWAIT_HEADERS: {
                CharSequence acceptEncoding;
                HttpContentEncoder.ensureHeaders(msg);
                assert (this.compressor == null);
                assert (msg instanceof HttpResponse);
                HttpResponse res = (HttpResponse)msg;
                int code = res.status().code();
                if (code == CONTINUE_CODE) {
                    acceptEncoding = null;
                } else {
                    acceptEncoding = this.acceptEncodingQueue.poll();
                    if (acceptEncoding == null) {
                        throw new IllegalStateException("cannot send more responses than requests");
                    }
                }
                if (HttpContentEncoder.isPassthru(res.protocolVersion(), code, acceptEncoding)) {
                    out.add(res);
                    dispose = false;
                    if (isFull) break;
                    this.state = State.PASS_THROUGH;
                    break;
                }
                if (isFull && ((LastHttpContent)((Object)res)).payload().readableBytes() == 0) {
                    out.add(res);
                    dispose = false;
                    break;
                }
                assert (acceptEncoding != null);
                Result result = this.beginEncode(res, acceptEncoding.toString());
                if (result == null) {
                    out.add(res);
                    dispose = false;
                    if (isFull) break;
                    this.state = State.PASS_THROUGH;
                    break;
                }
                this.compressor = result.contentCompressor();
                res.headers().set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, (Object)result.targetContentEncoding());
                if (isFull) {
                    DefaultHttpResponse newRes = new DefaultHttpResponse(res.protocolVersion(), res.status());
                    newRes.headers().set(res.headers());
                    out.add(newRes);
                    HttpContentEncoder.ensureContent(res);
                    this.encodeFullResponse(ctx, newRes, (HttpContent)((Object)res), out);
                    break;
                }
                res.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                res.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                out.add(res);
                dispose = false;
                this.state = State.AWAIT_CONTENT;
                if (!(msg instanceof HttpContent)) break;
            }
            case AWAIT_CONTENT: {
                HttpContentEncoder.ensureContent(msg);
                if (!this.encodeContent(ctx, (HttpContent)msg, out)) break;
                this.state = State.AWAIT_HEADERS;
                break;
            }
            case PASS_THROUGH: {
                HttpContentEncoder.ensureContent(msg);
                out.add(msg);
                dispose = false;
                if (!(msg instanceof LastHttpContent)) break;
                this.state = State.AWAIT_HEADERS;
            }
        }
        if (dispose) {
            Resource.dispose((Object)msg);
        }
    }

    private void encodeFullResponse(ChannelHandlerContext ctx, HttpResponse newRes, HttpContent<?> content, List<Object> out) {
        int existingMessages = out.size();
        this.encodeContent(ctx, content, out);
        if (HttpUtil.isContentLengthSet(newRes)) {
            int messageSize = 0;
            for (int i = existingMessages; i < out.size(); ++i) {
                Object item = out.get(i);
                if (!(item instanceof HttpContent)) continue;
                messageSize += ((HttpContent)item).payload().readableBytes();
            }
            HttpUtil.setContentLength(newRes, messageSize);
        } else {
            newRes.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
    }

    private static boolean isPassthru(HttpVersion version, int code, CharSequence httpMethod) {
        return code < 200 || code == 204 || code == 304 || httpMethod == ZERO_LENGTH_HEAD || httpMethod == ZERO_LENGTH_CONNECT && code == 200 || version == HttpVersion.HTTP_1_0;
    }

    private static void ensureHeaders(HttpObject msg) {
        if (!(msg instanceof HttpResponse)) {
            throw new IllegalStateException("unexpected message type: " + msg.getClass().getName() + " (expected: " + HttpResponse.class.getSimpleName() + ")");
        }
    }

    private static void ensureContent(HttpObject msg) {
        if (!(msg instanceof HttpContent)) {
            throw new IllegalStateException("unexpected message type: " + msg.getClass().getName() + " (expected: " + HttpContent.class.getSimpleName() + ")");
        }
    }

    private boolean encodeContent(ChannelHandlerContext ctx, HttpContent<?> c, List<Object> out) {
        Buffer content = c.payload();
        this.encode(content, ctx.bufferAllocator(), out);
        if (c instanceof LastHttpContent) {
            this.finishEncode(ctx.bufferAllocator(), out);
            LastHttpContent last = (LastHttpContent)c;
            HttpHeaders headers = last.trailingHeaders();
            if (headers.isEmpty()) {
                out.add(new EmptyLastHttpContent(ctx.bufferAllocator()));
            } else {
                out.add(new DefaultLastHttpContent(ctx.bufferAllocator().allocate(0), headers));
            }
            return true;
        }
        return false;
    }

    protected abstract Result beginEncode(HttpResponse var1, String var2) throws Exception;

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanupSafely(ctx);
        super.handlerRemoved(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanupSafely(ctx);
        super.channelInactive(ctx);
    }

    private void cleanup() {
        if (this.compressor != null) {
            try {
                this.compressor.close();
            }
            finally {
                this.compressor = null;
            }
        }
    }

    private void cleanupSafely(ChannelHandlerContext ctx) {
        try {
            this.cleanup();
        }
        catch (Throwable cause) {
            ctx.fireChannelExceptionCaught(cause);
        }
    }

    private void encode(Buffer in, BufferAllocator allocator, List<Object> out) {
        Buffer compressed = this.compressor.compress(in, allocator);
        if (compressed.readableBytes() == 0) {
            compressed.close();
            return;
        }
        out.add(new DefaultHttpContent(compressed));
    }

    private void finishEncode(BufferAllocator allocator, List<Object> out) {
        Buffer trailer = this.compressor.finish(allocator);
        if (trailer.readableBytes() == 0) {
            trailer.close();
            return;
        }
        out.add(new DefaultHttpContent(trailer));
        this.compressor = null;
    }

    public static final class Result {
        private final String targetContentEncoding;
        private final Compressor contentCompressor;

        public Result(String targetContentEncoding, Compressor contentCompressor) {
            Objects.requireNonNull(targetContentEncoding, "targetContentEncoding");
            Objects.requireNonNull(contentCompressor, "contentCompressor");
            this.targetContentEncoding = targetContentEncoding;
            this.contentCompressor = contentCompressor;
        }

        public String targetContentEncoding() {
            return this.targetContentEncoding;
        }

        public Compressor contentCompressor() {
            return this.contentCompressor;
        }
    }

    private static enum State {
        PASS_THROUGH,
        AWAIT_HEADERS,
        AWAIT_CONTENT;

    }
}

