/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.FileRegion;
import io.netty5.handler.codec.MessageToMessageEncoder;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpHeaders;
import io.netty5.handler.codec.http.HttpHeadersEncoder;
import io.netty5.handler.codec.http.HttpMessage;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.util.CharsetUtil;
import io.netty5.util.Resource;
import io.netty5.util.internal.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class HttpObjectEncoder<H extends HttpMessage>
extends MessageToMessageEncoder<Object> {
    static final short CRLF_SHORT = 3338;
    private static final int ZERO_CRLF_MEDIUM = 3149066;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final float HEADERS_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_WEIGHT_HISTORICAL = 0.8f;
    private static final float TRAILERS_WEIGHT_NEW = 0.2f;
    private static final float TRAILERS_WEIGHT_HISTORICAL = 0.8f;
    private static final int ST_INIT = 0;
    private static final int ST_CONTENT_NON_CHUNK = 1;
    private static final int ST_CONTENT_CHUNK = 2;
    private static final int ST_CONTENT_ALWAYS_EMPTY = 3;
    private Supplier<Buffer> crlfBufferSupplier;
    private Supplier<Buffer> zeroCrlfCrlfBufferSupplier;
    private int state = 0;
    private float headersEncodedSizeAccumulator = 256.0f;
    private float trailersEncodedSizeAccumulator = 256.0f;

    protected void encodeAndClose(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        Buffer buf = null;
        if (msg instanceof HttpMessage) {
            if (this.state != 0) {
                throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName((Object)msg) + ", state: " + this.state);
            }
            HttpMessage m = (HttpMessage)msg;
            buf = ctx.bufferAllocator().allocate((int)this.headersEncodedSizeAccumulator);
            this.encodeInitialLine(buf, m);
            this.state = this.isContentAlwaysEmpty(m) ? 3 : (HttpUtil.isTransferEncodingChunked(m) ? 2 : 1);
            this.sanitizeHeadersBeforeEncode(m, this.state == 3);
            this.encodeHeaders(m.headers(), buf);
            buf.writeShort((short)3338);
            this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
        }
        if (msg instanceof Buffer && ((Buffer)msg).readableBytes() == 0) {
            out.add(msg);
            return;
        }
        if (msg instanceof HttpContent || msg instanceof Buffer || msg instanceof FileRegion) {
            switch (this.state) {
                case 0: {
                    throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName((Object)msg) + ", state: " + this.state);
                }
                case 1: {
                    long contentLength = HttpObjectEncoder.contentLength(msg);
                    if (contentLength > 0L) {
                        if (buf != null && (long)buf.writableBytes() >= contentLength && msg instanceof HttpContent) {
                            buf.writeBytes(((HttpContent)msg).payload());
                            Resource.dispose((Object)msg);
                            out.add(buf);
                        } else {
                            if (buf != null) {
                                out.add(buf);
                            }
                            out.add(HttpObjectEncoder.encode(msg));
                        }
                        if (!(msg instanceof LastHttpContent)) break;
                        this.state = 0;
                        break;
                    }
                }
                case 3: {
                    if (buf != null) {
                        out.add(buf);
                        break;
                    }
                    out.add(ctx.bufferAllocator().allocate(0));
                    break;
                }
                case 2: {
                    if (buf != null) {
                        out.add(buf);
                    }
                    this.encodeChunkedContent(ctx, msg, HttpObjectEncoder.contentLength(msg), out);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (msg instanceof LastHttpContent) {
                this.state = 0;
            }
        } else if (buf != null) {
            out.add(buf);
        }
    }

    protected void encodeHeaders(HttpHeaders headers, Buffer buf) {
        Iterator<Map.Entry<CharSequence, CharSequence>> iter = headers.iteratorCharSequence();
        while (iter.hasNext()) {
            Map.Entry<CharSequence, CharSequence> header = iter.next();
            HttpHeadersEncoder.encoderHeader(header.getKey(), header.getValue(), buf);
        }
    }

    private void encodeChunkedContent(ChannelHandlerContext ctx, Object msg, long contentLength, List<Object> out) {
        Buffer buf;
        if (contentLength > 0L) {
            String lengthHex = Long.toHexString(contentLength);
            buf = ctx.bufferAllocator().allocate(lengthHex.length() + 2);
            buf.writeCharSequence((CharSequence)lengthHex, CharsetUtil.US_ASCII);
            buf.writeShort((short)3338);
            out.add(buf);
            out.add(HttpObjectEncoder.encode(msg));
            out.add(this.crlfBuffer(ctx.bufferAllocator()));
        }
        if (msg instanceof LastHttpContent) {
            HttpHeaders headers = ((LastHttpContent)msg).trailingHeaders();
            if (headers.isEmpty()) {
                out.add(this.zeroCrlfCrlfBuffer(ctx.bufferAllocator()));
            } else {
                buf = ctx.bufferAllocator().allocate((int)this.trailersEncodedSizeAccumulator);
                buf.writeMedium(3149066);
                this.encodeHeaders(headers, buf);
                buf.writeShort((short)3338);
                this.trailersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(buf.readableBytes()) + 0.8f * this.trailersEncodedSizeAccumulator;
                out.add(buf);
            }
        } else if (contentLength == 0L) {
            out.add(HttpObjectEncoder.encode(msg));
        }
    }

    protected void sanitizeHeadersBeforeEncode(H msg, boolean isAlwaysEmpty) {
    }

    protected boolean isContentAlwaysEmpty(H msg) {
        return false;
    }

    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return msg instanceof HttpObject || msg instanceof Buffer || msg instanceof FileRegion;
    }

    private static Object encode(Object msg) {
        if (msg instanceof Buffer) {
            return msg;
        }
        if (msg instanceof HttpContent) {
            return ((HttpContent)msg).payload();
        }
        if (msg instanceof FileRegion) {
            return msg;
        }
        Resource.dispose((Object)msg);
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName((Object)msg));
    }

    private static long contentLength(Object msg) {
        if (msg instanceof HttpContent) {
            return ((HttpContent)msg).payload().readableBytes();
        }
        if (msg instanceof Buffer) {
            return ((Buffer)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).count();
        }
        Resource.dispose((Object)msg);
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName((Object)msg));
    }

    private static int padSizeForAccumulation(int readableBytes) {
        return (readableBytes << 2) / 3;
    }

    protected abstract void encodeInitialLine(Buffer var1, H var2) throws Exception;

    protected Buffer crlfBuffer(BufferAllocator allocator) {
        if (this.crlfBufferSupplier == null) {
            this.crlfBufferSupplier = allocator.constBufferSupplier(CRLF);
        }
        return this.crlfBufferSupplier.get();
    }

    protected Buffer zeroCrlfCrlfBuffer(BufferAllocator allocator) {
        if (this.zeroCrlfCrlfBufferSupplier == null) {
            this.zeroCrlfCrlfBufferSupplier = allocator.constBufferSupplier(ZERO_CRLF_CRLF);
        }
        return this.zeroCrlfCrlfBufferSupplier.get();
    }
}

