/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.util.Resource;

public class HttpServerExpectContinueHandler
implements ChannelHandler {
    protected HttpResponse acceptMessage(BufferAllocator allocator, HttpRequest request) {
        return HttpServerExpectContinueHandler.newEmptyResponse(allocator, HttpResponseStatus.CONTINUE);
    }

    protected HttpResponse rejectResponse(BufferAllocator allocator, HttpRequest request) {
        return HttpServerExpectContinueHandler.newEmptyResponse(allocator, HttpResponseStatus.EXPECTATION_FAILED);
    }

    private static DefaultFullHttpResponse newEmptyResponse(BufferAllocator allocator, HttpResponseStatus status) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, allocator.allocate(0));
        resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        return resp;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest req;
        if (msg instanceof HttpRequest && HttpUtil.is100ContinueExpected(req = (HttpRequest)msg)) {
            HttpResponse accept = this.acceptMessage(ctx.bufferAllocator(), req);
            if (accept == null) {
                HttpResponse rejection = this.rejectResponse(ctx.bufferAllocator(), req);
                Resource.dispose((Object)msg);
                ctx.writeAndFlush((Object)rejection).addListener((Object)ctx.channel(), ChannelFutureListeners.CLOSE_ON_FAILURE);
                return;
            }
            ctx.writeAndFlush((Object)accept).addListener((Object)ctx.channel(), ChannelFutureListeners.CLOSE_ON_FAILURE);
            req.headers().remove((CharSequence)HttpHeaderNames.EXPECT);
        }
        ctx.fireChannelRead(msg);
    }
}

