/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http;

import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.internal.DelegatingChannelHandlerContext;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpHeaderValues;
import io.netty5.handler.codec.http.HttpHeaders;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpObjectAggregator;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.util.AsciiString;
import io.netty5.util.Resource;
import io.netty5.util.Send;
import io.netty5.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class HttpServerUpgradeHandler<C extends HttpContent<C>>
extends HttpObjectAggregator<C> {
    private final SourceCodec sourceCodec;
    private final UpgradeCodecFactory upgradeCodecFactory;
    private final boolean validateHeaders;
    private boolean handlingUpgrade;

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory) {
        this(sourceCodec, upgradeCodecFactory, 0);
    }

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int maxContentLength) {
        this(sourceCodec, upgradeCodecFactory, maxContentLength, true);
    }

    public HttpServerUpgradeHandler(SourceCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory, int maxContentLength, boolean validateHeaders) {
        super(maxContentLength);
        this.sourceCodec = Objects.requireNonNull(sourceCodec, "sourceCodec");
        this.upgradeCodecFactory = Objects.requireNonNull(upgradeCodecFactory, "upgradeCodecFactory");
        this.validateHeaders = validateHeaders;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void decodeAndClose(final ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (!this.handlingUpgrade) {
            if (!(msg instanceof HttpRequest)) {
                ctx.fireChannelRead((Object)msg);
                return;
            }
            HttpRequest req = (HttpRequest)msg;
            if (req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE) && this.shouldHandleUpgradeRequest(req)) {
                this.handlingUpgrade = true;
            } else {
                ctx.fireChannelRead((Object)msg);
                return;
            }
        }
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest fullRequest = (FullHttpRequest)msg;
            this.tryUpgrade(ctx, fullRequest);
            return;
        }
        super.decodeAndClose((ChannelHandlerContext)new DelegatingChannelHandlerContext(ctx){

            public ChannelHandlerContext fireChannelRead(Object msg) {
                HttpServerUpgradeHandler.this.handlingUpgrade = false;
                HttpServerUpgradeHandler.this.tryUpgrade(ctx, (FullHttpRequest)msg);
                return this;
            }
        }, (Object)msg);
    }

    private void tryUpgrade(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (!this.upgrade(ctx, request)) {
            ctx.fireChannelRead((Object)request);
        }
    }

    protected boolean shouldHandleUpgradeRequest(HttpRequest req) {
        return true;
    }

    private boolean upgrade(ChannelHandlerContext ctx, FullHttpRequest request) {
        List<CharSequence> requestedProtocols = HttpServerUpgradeHandler.splitHeader(request.headers().get((CharSequence)HttpHeaderNames.UPGRADE));
        int numRequestedProtocols = requestedProtocols.size();
        UpgradeCodec upgradeCodec = null;
        CharSequence upgradeProtocol = null;
        for (int i = 0; i < numRequestedProtocols; ++i) {
            CharSequence p = requestedProtocols.get(i);
            UpgradeCodec c = this.upgradeCodecFactory.newUpgradeCodec(p);
            if (c == null) continue;
            upgradeProtocol = p;
            upgradeCodec = c;
            break;
        }
        if (upgradeCodec == null) {
            return false;
        }
        List<String> connectionHeaderValues = request.headers().getAll((CharSequence)HttpHeaderNames.CONNECTION);
        if (connectionHeaderValues == null || connectionHeaderValues.isEmpty()) {
            return false;
        }
        StringBuilder concatenatedConnectionValue = new StringBuilder(connectionHeaderValues.size() * 10);
        for (CharSequence charSequence : connectionHeaderValues) {
            concatenatedConnectionValue.append(charSequence).append(',');
        }
        concatenatedConnectionValue.setLength(concatenatedConnectionValue.length() - 1);
        Collection<CharSequence> requiredHeaders = upgradeCodec.requiredUpgradeHeaders();
        List<CharSequence> list = HttpServerUpgradeHandler.splitHeader(concatenatedConnectionValue);
        if (!AsciiString.containsContentEqualsIgnoreCase(list, (CharSequence)HttpHeaderNames.UPGRADE) || !AsciiString.containsAllContentEqualsIgnoreCase(list, requiredHeaders)) {
            return false;
        }
        for (CharSequence requiredHeader : requiredHeaders) {
            if (request.headers().contains(requiredHeader)) continue;
            return false;
        }
        FullHttpResponse upgradeResponse = this.createUpgradeResponse(ctx.bufferAllocator(), upgradeProtocol);
        if (!upgradeCodec.prepareUpgradeResponse(ctx, request, upgradeResponse.headers())) {
            return false;
        }
        Future writeComplete = ctx.writeAndFlush((Object)upgradeResponse);
        this.sourceCodec.upgradeFrom(ctx);
        upgradeCodec.upgradeTo(ctx, request);
        ctx.fireChannelInboundEvent((Object)new UpgradeEvent(upgradeProtocol, request));
        ctx.pipeline().remove((ChannelHandler)this);
        writeComplete.addListener((Object)ctx.channel(), ChannelFutureListeners.CLOSE_ON_FAILURE);
        return true;
    }

    private FullHttpResponse createUpgradeResponse(BufferAllocator allocator, CharSequence upgradeProtocol) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, allocator.allocate(0), this.validateHeaders);
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)upgradeProtocol);
        return res;
    }

    private static List<CharSequence> splitHeader(CharSequence header) {
        StringBuilder builder = new StringBuilder(header.length());
        ArrayList<CharSequence> protocols = new ArrayList<CharSequence>(4);
        for (int i = 0; i < header.length(); ++i) {
            char c = header.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == ',') {
                protocols.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            protocols.add(builder.toString());
        }
        return protocols;
    }

    public static final class UpgradeEvent
    implements Resource<UpgradeEvent> {
        private final CharSequence protocol;
        private final FullHttpRequest upgradeRequest;

        UpgradeEvent(CharSequence protocol, FullHttpRequest upgradeRequest) {
            this.protocol = protocol;
            this.upgradeRequest = upgradeRequest;
        }

        public CharSequence protocol() {
            return this.protocol;
        }

        public FullHttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        public Send<UpgradeEvent> send() {
            return this.upgradeRequest.send().map(UpgradeEvent.class, req -> new UpgradeEvent(this.protocol, (FullHttpRequest)req));
        }

        public UpgradeEvent copy() {
            return new UpgradeEvent(this.protocol, (FullHttpRequest)this.upgradeRequest.copy());
        }

        public void close() {
            this.upgradeRequest.close();
        }

        public boolean isAccessible() {
            return this.upgradeRequest.isAccessible();
        }

        public UpgradeEvent touch(Object hint) {
            this.upgradeRequest.touch(hint);
            return this;
        }

        public String toString() {
            return "UpgradeEvent [protocol=" + this.protocol + ", upgradeRequest=" + this.upgradeRequest + "]";
        }
    }

    public static interface UpgradeCodecFactory {
        public UpgradeCodec newUpgradeCodec(CharSequence var1);
    }

    public static interface UpgradeCodec {
        public Collection<CharSequence> requiredUpgradeHeaders();

        public boolean prepareUpgradeResponse(ChannelHandlerContext var1, FullHttpRequest var2, HttpHeaders var3);

        public void upgradeTo(ChannelHandlerContext var1, FullHttpRequest var2);
    }

    public static interface SourceCodec {
        public void upgradeFrom(ChannelHandlerContext var1);
    }
}

