/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.cookie;

import io.netty5.handler.codec.http.cookie.Cookie;
import io.netty5.handler.codec.http.cookie.CookieEncoder;
import io.netty5.handler.codec.http.cookie.CookieUtil;
import io.netty5.handler.codec.http.cookie.DefaultCookie;
import io.netty5.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

public final class ClientCookieEncoder
extends CookieEncoder {
    public static final ClientCookieEncoder STRICT = new ClientCookieEncoder(true);
    public static final ClientCookieEncoder LAX = new ClientCookieEncoder(false);
    static final Comparator<Cookie> COOKIE_COMPARATOR = (c1, c2) -> {
        String path1 = c1.path();
        String path2 = c2.path();
        int len1 = path1 == null ? Integer.MAX_VALUE : path1.length();
        int len2 = path2 == null ? Integer.MAX_VALUE : path2.length();
        return len2 - len1;
    };

    private ClientCookieEncoder(boolean strict) {
        super(strict);
    }

    public String encode(String name, String value) {
        return this.encode((Cookie)new DefaultCookie(name, value));
    }

    public String encode(Cookie cookie) {
        StringBuilder buf = StringUtil.threadLocalStringBuilder();
        this.encode(buf, Objects.requireNonNull(cookie, "cookie"));
        return CookieUtil.stripTrailingSeparator(buf);
    }

    public String encode(Cookie ... cookies) {
        if (Objects.requireNonNull(cookies, "cookies").length == 0) {
            return null;
        }
        StringBuilder buf = StringUtil.threadLocalStringBuilder();
        if (this.strict) {
            if (cookies.length == 1) {
                this.encode(buf, cookies[0]);
            } else {
                Cookie[] cookiesSorted = Arrays.copyOf(cookies, cookies.length);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            for (Cookie c : cookies) {
                this.encode(buf, c);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    public String encode(Collection<? extends Cookie> cookies) {
        if (Objects.requireNonNull(cookies, "cookies").isEmpty()) {
            return null;
        }
        StringBuilder buf = StringUtil.threadLocalStringBuilder();
        if (this.strict) {
            if (cookies.size() == 1) {
                this.encode(buf, cookies.iterator().next());
            } else {
                Cookie[] cookiesSorted = cookies.toArray(new Cookie[0]);
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            for (Cookie cookie : cookies) {
                this.encode(buf, cookie);
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    public String encode(Iterable<? extends Cookie> cookies) {
        Iterator<? extends Cookie> cookiesIt = Objects.requireNonNull(cookies, "cookies").iterator();
        if (!cookiesIt.hasNext()) {
            return null;
        }
        StringBuilder buf = StringUtil.threadLocalStringBuilder();
        if (this.strict) {
            Cookie firstCookie = cookiesIt.next();
            if (!cookiesIt.hasNext()) {
                this.encode(buf, firstCookie);
            } else {
                Cookie[] cookiesSorted;
                if (cookies instanceof Collection) {
                    cookiesSorted = new Cookie[((Collection)cookies).size()];
                    cookiesSorted[0] = firstCookie;
                    int i = 1;
                    while (cookiesIt.hasNext()) {
                        cookiesSorted[i] = cookiesIt.next();
                        ++i;
                    }
                } else {
                    ArrayList<Cookie> cookiesList = new ArrayList<Cookie>();
                    cookiesList.add(firstCookie);
                    while (cookiesIt.hasNext()) {
                        cookiesList.add(cookiesIt.next());
                    }
                    cookiesSorted = cookiesList.toArray(new Cookie[0]);
                }
                Arrays.sort(cookiesSorted, COOKIE_COMPARATOR);
                for (Cookie c : cookiesSorted) {
                    this.encode(buf, c);
                }
            }
        } else {
            while (cookiesIt.hasNext()) {
                this.encode(buf, cookiesIt.next());
            }
        }
        return CookieUtil.stripTrailingSeparatorOrNull(buf);
    }

    private void encode(StringBuilder buf, Cookie c) {
        String name = c.name();
        String value = c.value() != null ? c.value() : "";
        this.validateCookie(name, value);
        if (c.wrap()) {
            CookieUtil.addQuoted(buf, name, value);
        } else {
            CookieUtil.add(buf, name, value);
        }
    }
}

