/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.StandardCharsets;

public class TextWebSocketFrame
extends WebSocketFrame {
    public TextWebSocketFrame(BufferAllocator allocator, String text) {
        super(TextWebSocketFrame.fromText(allocator, text));
    }

    public TextWebSocketFrame(Buffer binaryData) {
        super(binaryData);
    }

    public TextWebSocketFrame(BufferAllocator allocator, boolean finalFragment, int rsv, String text) {
        super(finalFragment, rsv, TextWebSocketFrame.fromText(allocator, text));
    }

    private TextWebSocketFrame(TextWebSocketFrame copyFrom, Buffer data) {
        super(copyFrom, data);
    }

    private static Buffer fromText(BufferAllocator allocator, String text) {
        if (text == null || text.isEmpty()) {
            return allocator.allocate(0);
        }
        return allocator.copyOf(text, StandardCharsets.UTF_8);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, Buffer binaryData) {
        super(finalFragment, rsv, binaryData);
    }

    public String text() {
        return this.binaryData().toString(StandardCharsets.UTF_8);
    }

    protected WebSocketFrame receive(Buffer buf) {
        return new TextWebSocketFrame(this, buf);
    }
}

