/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.api.Buffer;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty5.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.Utf8Validator;
import io.netty5.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;

public class Utf8FrameValidator
implements ChannelHandler {
    private final boolean closeOnProtocolViolation;
    private int fragmentedFramesCount;
    private Utf8Validator utf8Validator;

    public Utf8FrameValidator() {
        this(true);
    }

    public Utf8FrameValidator(boolean closeOnProtocolViolation) {
        this.closeOnProtocolViolation = closeOnProtocolViolation;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)((Object)msg);
            try {
                if (((WebSocketFrame)((Object)msg)).isFinalFragment()) {
                    if (!(frame instanceof PingWebSocketFrame)) {
                        this.fragmentedFramesCount = 0;
                        if (frame instanceof TextWebSocketFrame || this.utf8Validator != null && this.utf8Validator.isChecking()) {
                            this.checkUTF8String(frame.binaryData());
                            this.utf8Validator.finish();
                        }
                    }
                } else {
                    if (this.fragmentedFramesCount == 0) {
                        if (frame instanceof TextWebSocketFrame) {
                            this.checkUTF8String(frame.binaryData());
                        }
                    } else if (this.utf8Validator != null && this.utf8Validator.isChecking()) {
                        this.checkUTF8String(frame.binaryData());
                    }
                    ++this.fragmentedFramesCount;
                }
            }
            catch (CorruptedWebSocketFrameException e) {
                this.protocolViolation(ctx, frame, e);
            }
        }
        ctx.fireChannelRead(msg);
    }

    private void checkUTF8String(Buffer buffer) {
        if (this.utf8Validator == null) {
            this.utf8Validator = new Utf8Validator();
        }
        this.utf8Validator.check(buffer);
    }

    private void protocolViolation(ChannelHandlerContext ctx, WebSocketFrame frame, CorruptedWebSocketFrameException ex) {
        frame.close();
        if (this.closeOnProtocolViolation && ctx.channel().isOpen()) {
            WebSocketCloseStatus closeStatus = ex.closeStatus();
            String reasonText = ex.getMessage();
            if (reasonText == null) {
                reasonText = closeStatus.reasonText();
            }
            CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(ctx.bufferAllocator(), closeStatus.code(), reasonText);
            ctx.writeAndFlush((Object)closeFrame).addListener((Object)ctx, ChannelFutureListeners.CLOSE);
        }
        throw ex;
    }
}

