/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;
import io.netty5.handler.stream.ChunkedInput;
import java.util.Objects;

public final class WebSocketChunkedInput
implements ChunkedInput<WebSocketFrame> {
    private final ChunkedInput<Buffer> input;
    private final int rsv;

    public WebSocketChunkedInput(ChunkedInput<Buffer> input) {
        this(input, 0);
    }

    public WebSocketChunkedInput(ChunkedInput<Buffer> input, int rsv) {
        this.input = Objects.requireNonNull(input, "input");
        this.rsv = rsv;
    }

    public boolean isEndOfInput() throws Exception {
        return this.input.isEndOfInput();
    }

    public void close() throws Exception {
        this.input.close();
    }

    public WebSocketFrame readChunk(BufferAllocator allocator) throws Exception {
        Buffer buf = (Buffer)this.input.readChunk(allocator);
        if (buf == null) {
            return null;
        }
        return new ContinuationWebSocketFrame(this.input.isEndOfInput(), this.rsv, buf);
    }

    public long length() {
        return this.input.length();
    }

    public long progress() {
        return this.input.progress();
    }
}

