/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.api.Buffer;
import io.netty5.buffer.api.BufferAllocator;
import io.netty5.buffer.api.CompositeBuffer;
import io.netty5.channel.ChannelPipeline;
import io.netty5.handler.codec.MessageAggregator;
import io.netty5.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketFrame;

public class WebSocketFrameAggregator
extends MessageAggregator<WebSocketFrame, WebSocketFrame, ContinuationWebSocketFrame, WebSocketFrame> {
    public WebSocketFrameAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    protected WebSocketFrame tryStartMessage(Object msg) {
        return WebSocketFrameAggregator.isStartMessage(msg) ? (WebSocketFrame)((Object)msg) : null;
    }

    protected ContinuationWebSocketFrame tryContentMessage(Object msg) {
        return WebSocketFrameAggregator.isContentMessage(msg) ? (ContinuationWebSocketFrame)((Object)msg) : null;
    }

    protected boolean isLastContentMessage(ContinuationWebSocketFrame msg) {
        return WebSocketFrameAggregator.isContentMessage((Object)msg) && msg.isFinalFragment();
    }

    protected boolean isAggregated(Object msg) throws Exception {
        if (!(msg instanceof WebSocketFrame)) {
            return false;
        }
        WebSocketFrame frame = (WebSocketFrame)((Object)msg);
        if (frame.isFinalFragment()) {
            return !WebSocketFrameAggregator.isContentMessage(msg);
        }
        return !WebSocketFrameAggregator.isStartMessage(msg) && !WebSocketFrameAggregator.isContentMessage(msg);
    }

    protected boolean isContentLengthInvalid(WebSocketFrame start, int maxContentLength) {
        return false;
    }

    protected Object newContinueResponse(WebSocketFrame start, int maxContentLength, ChannelPipeline pipeline) {
        return null;
    }

    protected boolean closeAfterContinueResponse(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected boolean ignoreContentAfterContinueResponse(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected int lengthForContent(ContinuationWebSocketFrame msg) {
        return msg.binaryData().readableBytes();
    }

    protected int lengthForAggregation(WebSocketFrame msg) {
        return msg.binaryData().readableBytes();
    }

    protected WebSocketFrame beginAggregation(BufferAllocator allocator, WebSocketFrame start) {
        if (start instanceof TextWebSocketFrame) {
            CompositeBuffer content = allocator.compose(start.binaryData().send());
            return new TextWebSocketFrame(true, start.rsv(), (Buffer)content);
        }
        if (start instanceof BinaryWebSocketFrame) {
            CompositeBuffer content = allocator.compose(start.binaryData().send());
            return new BinaryWebSocketFrame(true, start.rsv(), (Buffer)content);
        }
        throw new Error();
    }

    protected void aggregate(BufferAllocator allocator, WebSocketFrame aggregated, ContinuationWebSocketFrame content) throws Exception {
        CompositeBuffer payload = (CompositeBuffer)aggregated.binaryData();
        payload.extendWith(content.binaryData().send());
    }

    private static boolean isStartMessage(Object msg) {
        return msg instanceof TextWebSocketFrame || msg instanceof BinaryWebSocketFrame;
    }

    private static boolean isContentMessage(Object msg) {
        return msg instanceof ContinuationWebSocketFrame;
    }
}

