/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.buffer.api.BufferAllocator;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelOutboundInvoker;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.handler.codec.http.FullHttpRequest;
import io.netty5.handler.codec.http.FullHttpResponse;
import io.netty5.handler.codec.http.HttpContentCompressor;
import io.netty5.handler.codec.http.HttpHeaders;
import io.netty5.handler.codec.http.HttpObjectAggregator;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpRequestDecoder;
import io.netty5.handler.codec.http.HttpResponseEncoder;
import io.netty5.handler.codec.http.HttpServerCodec;
import io.netty5.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty5.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty5.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty5.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty5.handler.codec.http.websocketx.WebSocketVersion;
import io.netty5.util.ReferenceCountUtil;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public abstract class WebSocketServerHandshaker {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketServerHandshaker.class);
    private final String uri;
    private final String[] subprotocols;
    private final WebSocketVersion version;
    private final WebSocketDecoderConfig decoderConfig;
    private String selectedSubprotocol;
    public static final String SUB_PROTOCOL_WILDCARD = "*";

    protected WebSocketServerHandshaker(WebSocketVersion version, String uri, String subprotocols, int maxFramePayloadLength) {
        this(version, uri, subprotocols, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(maxFramePayloadLength).build());
    }

    protected WebSocketServerHandshaker(WebSocketVersion version, String uri, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        this.version = version;
        this.uri = uri;
        if (subprotocols != null) {
            String[] subprotocolArray = subprotocols.split(",");
            for (int i = 0; i < subprotocolArray.length; ++i) {
                subprotocolArray[i] = subprotocolArray[i].trim();
            }
            this.subprotocols = subprotocolArray;
        } else {
            this.subprotocols = EmptyArrays.EMPTY_STRINGS;
        }
        this.decoderConfig = Objects.requireNonNull(decoderConfig, "decoderConfig");
    }

    public String uri() {
        return this.uri;
    }

    public Set<String> subprotocols() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        Collections.addAll(ret, this.subprotocols);
        return ret;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.decoderConfig.maxFramePayloadLength();
    }

    public WebSocketDecoderConfig decoderConfig() {
        return this.decoderConfig;
    }

    public Future<Void> handshake(Channel channel, FullHttpRequest req) {
        return this.handshake(channel, req, null);
    }

    public final Future<Void> handshake(Channel channel, FullHttpRequest req, HttpHeaders responseHeaders) {
        String encoderName;
        ChannelHandlerContext ctx;
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        FullHttpResponse response = this.newHandshakeResponse(channel.bufferAllocator(), req, responseHeaders);
        ChannelPipeline p = channel.pipeline();
        if (p.get(HttpObjectAggregator.class) != null) {
            p.remove(HttpObjectAggregator.class);
        }
        if (p.get(HttpContentCompressor.class) != null) {
            p.remove(HttpContentCompressor.class);
        }
        if ((ctx = p.context(HttpRequestDecoder.class)) == null) {
            ctx = p.context(HttpServerCodec.class);
            if (ctx == null) {
                return channel.newFailedFuture((Throwable)new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
            }
            p.addBefore(ctx.name(), "wsencoder", (ChannelHandler)this.newWebSocketEncoder());
            p.addBefore(ctx.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            encoderName = ctx.name();
        } else {
            p.replace(ctx.name(), "wsdecoder", (ChannelHandler)this.newWebsocketDecoder());
            encoderName = p.context(HttpResponseEncoder.class).name();
            p.addBefore(encoderName, "wsencoder", (ChannelHandler)this.newWebSocketEncoder());
        }
        return channel.writeAndFlush((Object)response).addListener((Object)channel, (ch, future) -> {
            if (future.isSuccess()) {
                ChannelPipeline p1 = ch.pipeline();
                p1.remove(encoderName);
            }
        });
    }

    public Future<Void> handshake(Channel channel, HttpRequest req) {
        return this.handshake(channel, req, null);
    }

    public final Future<Void> handshake(final Channel channel, HttpRequest req, final HttpHeaders responseHeaders) {
        ChannelPipeline p;
        ChannelHandlerContext ctx;
        if (req instanceof FullHttpRequest) {
            return this.handshake(channel, (FullHttpRequest)req, responseHeaders);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WebSocket version {} server handshake", (Object)channel, (Object)this.version());
        }
        if ((ctx = (p = channel.pipeline()).context(HttpRequestDecoder.class)) == null && (ctx = p.context(HttpServerCodec.class)) == null) {
            return channel.newFailedFuture((Throwable)new IllegalStateException("No HttpDecoder and no HttpServerCodec in the pipeline"));
        }
        final Promise promise = channel.newPromise();
        String aggregatorName = "httpAggregator";
        p.addAfter(ctx.name(), aggregatorName, new HttpObjectAggregator(8192));
        p.addAfter(aggregatorName, "handshaker", (ChannelHandler)new SimpleChannelInboundHandler<FullHttpRequest>(){

            protected void messageReceived(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
                ctx.pipeline().remove((ChannelHandler)this);
                WebSocketServerHandshaker.this.handshake(channel, msg, responseHeaders);
            }

            public void channelExceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                promise.tryFailure(cause);
                ctx.fireChannelExceptionCaught(cause);
                ctx.pipeline().remove((ChannelHandler)this);
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                if (!promise.isDone()) {
                    promise.tryFailure((Throwable)new ClosedChannelException());
                }
                ctx.fireChannelInactive();
            }
        });
        try {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)req));
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
        return promise.asFuture();
    }

    protected abstract FullHttpResponse newHandshakeResponse(BufferAllocator var1, FullHttpRequest var2, HttpHeaders var3);

    public Future<Void> close(Channel channel, CloseWebSocketFrame frame) {
        Objects.requireNonNull(channel, "channel");
        return WebSocketServerHandshaker.close0((ChannelOutboundInvoker)channel, frame);
    }

    public Future<Void> close(ChannelHandlerContext ctx, CloseWebSocketFrame frame) {
        Objects.requireNonNull(ctx, "ctx");
        return WebSocketServerHandshaker.close0((ChannelOutboundInvoker)ctx, frame);
    }

    private static Future<Void> close0(ChannelOutboundInvoker invoker, CloseWebSocketFrame frame) {
        return invoker.writeAndFlush((Object)frame).addListener((Object)invoker, ChannelFutureListeners.CLOSE);
    }

    protected String selectSubprotocol(String requestedSubprotocols) {
        String[] requestedSubprotocolArray;
        if (requestedSubprotocols == null || this.subprotocols.length == 0) {
            return null;
        }
        for (String p : requestedSubprotocolArray = requestedSubprotocols.split(",")) {
            String requestedSubprotocol = p.trim();
            for (String supportedSubprotocol : this.subprotocols) {
                if (!SUB_PROTOCOL_WILDCARD.equals(supportedSubprotocol) && !requestedSubprotocol.equals(supportedSubprotocol)) continue;
                this.selectedSubprotocol = requestedSubprotocol;
                return requestedSubprotocol;
            }
        }
        return null;
    }

    public String selectedSubprotocol() {
        return this.selectedSubprotocol;
    }

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();
}

