/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.channel.ChannelFutureListeners;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelPipeline;
import io.netty5.handler.codec.http.DefaultFullHttpResponse;
import io.netty5.handler.codec.http.HttpHeaderNames;
import io.netty5.handler.codec.http.HttpMethod;
import io.netty5.handler.codec.http.HttpObject;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.HttpResponse;
import io.netty5.handler.codec.http.HttpResponseStatus;
import io.netty5.handler.codec.http.HttpUtil;
import io.netty5.handler.codec.http.HttpVersion;
import io.netty5.handler.codec.http.websocketx.WebSocketHandshakeTimeoutException;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshakeCompletionEvent;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty5.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty5.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty5.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty5.handler.ssl.SslHandler;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class WebSocketServerProtocolHandshakeHandler
implements ChannelHandler {
    private final WebSocketServerProtocolConfig serverConfig;
    private Promise<Void> handshakePromise;
    private boolean isWebSocketPath;

    WebSocketServerProtocolHandshakeHandler(WebSocketServerProtocolConfig serverConfig) {
        this.serverConfig = Objects.requireNonNull(serverConfig, "serverConfig");
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.handshakePromise = ctx.newPromise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpObject httpObject = (HttpObject)msg;
        if (httpObject instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)httpObject;
            this.isWebSocketPath = this.isWebSocketPath(req);
            if (!this.isWebSocketPath) {
                ctx.fireChannelRead(msg);
                return;
            }
            try {
                if (!HttpMethod.GET.equals(req.method())) {
                    WebSocketServerProtocolHandshakeHandler.sendHttpResponse(ctx, req, new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN, ctx.bufferAllocator().allocate(0)));
                    return;
                }
                WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(WebSocketServerProtocolHandshakeHandler.getWebSocketLocation(ctx.pipeline(), req, this.serverConfig.websocketPath()), this.serverConfig.subprotocols(), this.serverConfig.decoderConfig());
                WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(req);
                Promise<Void> localHandshakePromise = this.handshakePromise;
                if (handshaker == null) {
                    WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(ctx.channel());
                }
                WebSocketServerProtocolHandler.setHandshaker(ctx.channel(), handshaker);
                Future<Void> handshakeFuture = handshaker.handshake(ctx.channel(), req);
                handshakeFuture.addListener(future -> {
                    if (future.isFailed()) {
                        localHandshakePromise.tryFailure(future.cause());
                        ctx.fireChannelExceptionCaught(future.cause());
                    } else {
                        localHandshakePromise.trySuccess(null);
                        ctx.fireChannelInboundEvent((Object)new WebSocketServerHandshakeCompletionEvent(handshaker.version(), req.uri(), req.headers(), handshaker.selectedSubprotocol()));
                    }
                    ctx.pipeline().remove((ChannelHandler)this);
                });
                this.applyHandshakeTimeout(ctx);
            }
            finally {
                if (req instanceof AutoCloseable) {
                    ((AutoCloseable)((Object)req)).close();
                }
            }
        } else if (!this.isWebSocketPath) {
            ctx.fireChannelRead(msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private boolean isWebSocketPath(HttpRequest req) {
        boolean checkNextUri;
        String websocketPath = this.serverConfig.websocketPath();
        String uri = req.uri();
        boolean checkStartUri = uri.startsWith(websocketPath);
        boolean bl = checkNextUri = "/".equals(websocketPath) || this.checkNextUri(uri, websocketPath);
        return this.serverConfig.checkStartsWith() ? checkStartUri && checkNextUri : uri.equals(websocketPath);
    }

    private boolean checkNextUri(String uri, String websocketPath) {
        int len = websocketPath.length();
        if (uri.length() > len) {
            char nextUri = uri.charAt(len);
            return nextUri == '/' || nextUri == '?';
        }
        return true;
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        Future f = ctx.writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive(req) || res.status().code() != 200) {
            f.addListener((Object)ctx, ChannelFutureListeners.CLOSE);
        }
    }

    private static String getWebSocketLocation(ChannelPipeline cp, HttpRequest req, String path) {
        String protocol = "ws";
        if (cp.get(SslHandler.class) != null) {
            protocol = "wss";
        }
        String host = req.headers().get((CharSequence)HttpHeaderNames.HOST);
        return protocol + "://" + host + path;
    }

    private void applyHandshakeTimeout(ChannelHandlerContext ctx) {
        Promise<Void> localHandshakePromise = this.handshakePromise;
        long handshakeTimeoutMillis = this.serverConfig.handshakeTimeoutMillis();
        if (handshakeTimeoutMillis <= 0L || localHandshakePromise.isDone()) {
            return;
        }
        Future timeoutFuture = ctx.executor().schedule(() -> {
            if (localHandshakePromise.isDone()) {
                return;
            }
            WebSocketHandshakeTimeoutException exception = new WebSocketHandshakeTimeoutException("handshake timed out after " + handshakeTimeoutMillis + "ms");
            if (localHandshakePromise.tryFailure((Throwable)exception)) {
                ctx.flush().fireChannelInboundEvent((Object)new WebSocketServerHandshakeCompletionEvent(exception)).close();
            }
        }, handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        localHandshakePromise.asFuture().addListener(f -> timeoutFuture.cancel());
    }
}

