/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.handler.codec.http.websocketx;

import io.netty5.util.CharsetUtil;
import io.netty5.util.concurrent.FastThreadLocal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.concurrent.ThreadLocalRandom;

final class WebSocketUtil {
    private static final String V13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final FastThreadLocal<MessageDigest> SHA1 = new FastThreadLocal<MessageDigest>(){

        protected MessageDigest initialValue() throws Exception {
            try {
                return MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("SHA-1 not supported on this platform - Outdated ?");
            }
        }
    };

    static byte[] sha1(byte[] data) {
        MessageDigest sha1Digest = (MessageDigest)SHA1.get();
        sha1Digest.reset();
        return sha1Digest.digest(data);
    }

    static String base64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    static byte[] randomBytes(int size) {
        byte[] bytes = new byte[size];
        ThreadLocalRandom.current().nextBytes(bytes);
        return bytes;
    }

    static String calculateV13Accept(String nonce) {
        String concat = nonce + V13_ACCEPT_GUID;
        byte[] sha1 = WebSocketUtil.sha1(concat.getBytes(CharsetUtil.US_ASCII));
        return WebSocketUtil.base64(sha1);
    }

    private WebSocketUtil() {
    }
}

